/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchdb.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.couchdb.services.CouchDbLocalContainerInfraService;
import org.apache.camel.test.infra.couchdb.services.CouchDbRemoteInfraService;
import org.apache.camel.test.infra.couchdb.services.CouchDbService;

public final class CouchDbServiceFactory {
    private CouchDbServiceFactory() {
    }

    public static SimpleTestServiceBuilder<CouchDbService> builder() {
        return new SimpleTestServiceBuilder("consul");
    }

    public static CouchDbService createService() {
        return (CouchDbService)CouchDbServiceFactory.builder().addLocalMapping(CouchDbLocalContainerTestService::new).addRemoteMapping(CouchDbRemoteTestService::new).build();
    }

    public static CouchDbService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final CouchDbService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<CouchDbService> instance = CouchDbServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonCouchDbService(new CouchDbLocalContainerTestService(), "couchdb")).addRemoteMapping(CouchDbRemoteTestService::new);
            INSTANCE = (CouchDbService)instance.build();
        }
    }

    public static class CouchDbRemoteTestService
    extends CouchDbRemoteInfraService
    implements CouchDbService {
    }

    public static class CouchDbLocalContainerTestService
    extends CouchDbLocalContainerInfraService
    implements CouchDbService {
    }

    static class SingletonCouchDbService
    extends SingletonService<CouchDbService>
    implements CouchDbService {
        public SingletonCouchDbService(CouchDbService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String host() {
            return ((CouchDbService)this.getService()).host();
        }

        @Override
        public int port() {
            return ((CouchDbService)this.getService()).port();
        }

        @Override
        public String getServiceAddress() {
            return ((CouchDbService)this.getService()).getServiceAddress();
        }
    }
}

