/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.dispatch.router.services;

import java.util.concurrent.Future;
import org.apache.camel.test.infra.common.TestUtils;
import org.apache.camel.test.infra.messaging.services.MessagingContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class DispatchRouterContainer
extends GenericContainer<DispatchRouterContainer>
implements MessagingContainer {
    private static final int DEFAULT_AMQP_PORT = 5672;
    private static final String FROM_IMAGE_NAME = "fedora:38";
    private static final String FROM_IMAGE_ARG = "FROMIMAGE";

    public DispatchRouterContainer() {
        super((Future)((ImageFromDockerfile)new ImageFromDockerfile("localhost/qpid-dispatch:camel", false).withFileFromClasspath("Dockerfile", "org/apache/camel/test/infra/dispatch/router/services/Dockerfile")).withBuildArg(FROM_IMAGE_ARG, TestUtils.prependHubImageNamePrefixIfNeeded((String)FROM_IMAGE_NAME)));
        this.withExposedPorts(new Integer[]{5672});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public int getAMQPPort() {
        return this.getMappedPort(5672);
    }

    public String getAMQPEndpoint() {
        return String.format("amqp://%s:%d", this.getHost(), this.getAMQPPort());
    }

    public String defaultEndpoint() {
        return this.getAMQPEndpoint();
    }
}

