/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.elasticsearch.services;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.elasticsearch.services.ElasticSearchInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=ElasticSearchInfraService.class, description="NoSQL Database Elasticsearch", serviceAlias={"elasticsearch"})
public class ElasticSearchLocalContainerInfraService
implements ElasticSearchInfraService,
ContainerService<ElasticsearchContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchLocalContainerInfraService.class);
    private static final int ELASTIC_SEARCH_PORT = 9200;
    private static final String USER_NAME = "elastic";
    private static final String PASSWORD = "s3cret";
    private Path certPath;
    private SSLContext sslContext;
    private final ElasticsearchContainer container;

    public ElasticSearchLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(ElasticSearchLocalContainerInfraService.class, (String)"elasticsearch.container"));
    }

    public ElasticSearchLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public ElasticSearchLocalContainerInfraService(ElasticsearchContainer container) {
        this.container = container;
    }

    protected ElasticsearchContainer initContainer(final String imageName) {
        class TestInfraElasticsearchContainer
        extends ElasticsearchContainer {
            public TestInfraElasticsearchContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string).asCompatibleSubstituteFor("docker.elastic.co/elasticsearch/elasticsearch"));
                this.withPassword(ElasticSearchLocalContainerInfraService.PASSWORD);
                if (fixedPort) {
                    this.addFixedExposedPort(9200, 9200);
                } else {
                    this.withExposedPorts(new Integer[]{9200});
                }
                this.setWaitStrategy(new LogMessageWaitStrategy().withRegEx(".*(\"message\":\\s?\"started[\\s?|\"].*|] started\n$)").withStartupTimeout(Duration.ofSeconds(90L)));
            }
        }
        return new TestInfraElasticsearchContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    @Override
    public int getPort() {
        return this.container.getMappedPort(9200);
    }

    @Override
    public String getElasticSearchHost() {
        return this.container.getHost();
    }

    @Override
    public String getHttpHostAddress() {
        return this.container.getHttpHostAddress();
    }

    public void registerProperties() {
        System.setProperty("elasticsearch.host", this.getElasticSearchHost());
        System.setProperty("elasticsearch.port", String.valueOf(this.getPort()));
        this.getContainer().caCertAsBytes().ifPresent(content -> {
            try {
                this.certPath = Files.createTempFile("http_ca", ".crt", new FileAttribute[0]);
                Files.write(this.certPath, content, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.sslContext = this.getContainer().createSslContextFromCa();
        });
    }

    public void initialize() {
        LOG.info("Trying to start the ElasticSearch container");
        ContainerEnvironmentUtil.configureContainerStartup((GenericContainer)this.container, (String)"elasticsearch.container.startup.attempts", (int)2);
        this.container.start();
        this.registerProperties();
        LOG.info("ElasticSearch instance running at {}", (Object)this.getHttpHostAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the ElasticSearch container");
        this.container.stop();
    }

    public ElasticsearchContainer getContainer() {
        return this.container;
    }

    @Override
    public Optional<String> getCertificatePath() {
        return Optional.ofNullable(this.certPath).map(Objects::toString);
    }

    @Override
    public Optional<SSLContext> getSslContext() {
        return Optional.ofNullable(this.sslContext);
    }

    @Override
    public String getUsername() {
        return USER_NAME;
    }

    @Override
    public String getPassword() {
        return PASSWORD;
    }
}

