/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.elasticsearch.services;

import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.elasticsearch.services.ElasticSearchLocalContainerInfraService;
import org.apache.camel.test.infra.elasticsearch.services.ElasticSearchService;
import org.apache.camel.test.infra.elasticsearch.services.RemoteElasticSearchInfraService;

public final class ElasticSearchServiceFactory {
    private ElasticSearchServiceFactory() {
    }

    public static SimpleTestServiceBuilder<ElasticSearchService> builder() {
        return new SimpleTestServiceBuilder("elasticsearch");
    }

    public static ElasticSearchService createService() {
        return (ElasticSearchService)ElasticSearchServiceFactory.builder().addLocalMapping(ElasticSearchLocalContainerTestService::new).addRemoteMapping(RemoteElasticSearchTestService::new).build();
    }

    public static ElasticSearchService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final ElasticSearchService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<ElasticSearchService> instance = ElasticSearchServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonElasticSearchService(new ElasticSearchLocalContainerTestService(), "elastic")).addRemoteMapping(RemoteElasticSearchTestService::new);
            INSTANCE = (ElasticSearchService)instance.build();
        }
    }

    public static class RemoteElasticSearchTestService
    extends RemoteElasticSearchInfraService
    implements ElasticSearchService {
    }

    public static class ElasticSearchLocalContainerTestService
    extends ElasticSearchLocalContainerInfraService
    implements ElasticSearchService {
    }

    static class SingletonElasticSearchService
    extends SingletonService<ElasticSearchService>
    implements ElasticSearchService {
        public SingletonElasticSearchService(ElasticSearchService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public int getPort() {
            return ((ElasticSearchService)this.getService()).getPort();
        }

        @Override
        public String getElasticSearchHost() {
            return ((ElasticSearchService)this.getService()).getElasticSearchHost();
        }

        @Override
        public String getHttpHostAddress() {
            return ((ElasticSearchService)this.getService()).getHttpHostAddress();
        }

        @Override
        public Optional<String> getCertificatePath() {
            return ((ElasticSearchService)this.getService()).getCertificatePath();
        }

        @Override
        public Optional<SSLContext> getSslContext() {
            return ((ElasticSearchService)this.getService()).getSslContext();
        }

        @Override
        public String getUsername() {
            return ((ElasticSearchService)this.getService()).getUsername();
        }

        @Override
        public String getPassword() {
            return ((ElasticSearchService)this.getService()).getPassword();
        }
    }
}

