/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ftp.services.embedded;

import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FtpsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FtpsUtil.class);
    private static boolean checked;
    private static boolean hasRequiredAlgorithms;

    private FtpsUtil() {
    }

    public static boolean hasRequiredAlgorithms() {
        if (!checked) {
            hasRequiredAlgorithms = FtpsUtil.doCheck();
        }
        return hasRequiredAlgorithms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doCheck() {
        LOG.debug("Checking if the system has the required algorithms for the test execution");
        try {
            KeyManagerFactory.getInstance("SunX509");
            TrustManagerFactory.getInstance("SunX509");
            boolean bl = true;
            return bl;
        }
        catch (NoSuchAlgorithmException e) {
            String name = System.getProperty("os.name");
            String message = e.getMessage();
            LOG.warn("SunX509 is not available on this platform [{}] Testing is skipped! Real cause: {}", new Object[]{name, message, e});
            boolean bl = false;
            return bl;
        }
        finally {
            checked = true;
        }
    }
}

