/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.infinispan.services;

import java.util.function.Consumer;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.infinispan.services.InfinispanInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@InfraService(service=InfinispanInfraService.class, description="Distributed Database For High\u2011Performance Applications With In\u2011Memory Speed", serviceAlias={"infinispan"})
public class InfinispanLocalContainerInfraService
implements InfinispanInfraService,
ContainerService<GenericContainer<?>> {
    public static final String CONTAINER_NAME = "infinispan";
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "password";
    private static final Logger LOG = LoggerFactory.getLogger(InfinispanLocalContainerInfraService.class);
    private final GenericContainer container;
    private final boolean isNetworkHost = this.isHostNetworkMode();

    public InfinispanLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(InfinispanLocalContainerInfraService.class, (String)"infinispan.container"));
    }

    public InfinispanLocalContainerInfraService(String containerImage) {
        this.container = this.initContainer(containerImage, CONTAINER_NAME);
    }

    public InfinispanLocalContainerInfraService(GenericContainer container) {
        this.container = container;
    }

    protected GenericContainer initContainer(String imageName, String containerName) {
        Logger containerLog = LoggerFactory.getLogger((String)("container." + containerName));
        Slf4jLogConsumer logConsumer = new Slf4jLogConsumer(containerLog);
        GenericContainer c = new GenericContainer(imageName).withNetworkAliases(new String[]{containerName}).withEnv("USER", DEFAULT_USERNAME).withEnv("PASS", DEFAULT_PASSWORD).withLogConsumer((Consumer)logConsumer).withClasspathResourceMapping("infinispan.xml", "/user-config/infinispan.xml", BindMode.READ_ONLY).withCommand(new String[]{"-c", "/user-config/infinispan.xml"}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Infinispan.*Server.*started.*", (int)1));
        if (this.isNetworkHost) {
            c.withNetworkMode("host");
        } else {
            c.withExposedPorts(new Integer[]{11222}).waitingFor((WaitStrategy)Wait.forListeningPort());
        }
        return c;
    }

    public void registerProperties() {
        System.setProperty("infinispan.service.host", this.host());
        System.setProperty("infinispan.service.port", String.valueOf(this.port()));
        System.setProperty("infinispan.service.address", this.getServiceAddress());
        System.setProperty("infinispan.service.username", DEFAULT_USERNAME);
        System.setProperty("infinispan.service.password", DEFAULT_PASSWORD);
        System.setProperty("infinispan.service.network.mode.host", String.valueOf(this.isNetworkHost));
    }

    public void initialize() {
        LOG.info("Trying to start the Infinispan container");
        this.container.start();
        this.registerProperties();
        LOG.info("Infinispan instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Infinispan container");
        this.container.stop();
        System.clearProperty("infinispan.service.host");
        System.clearProperty("infinispan.service.port");
        System.clearProperty("infinispan.service.address");
        System.clearProperty("infinispan.service.username");
        System.clearProperty("infinispan.service.password");
        System.clearProperty("infinispan.service.network.mode.host");
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String getServiceAddress() {
        return String.format("%s:%d", this.host(), this.port());
    }

    @Override
    public int port() {
        return this.isNetworkHost ? 11222 : this.container.getMappedPort(11222);
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public String username() {
        return DEFAULT_USERNAME;
    }

    @Override
    public String password() {
        return DEFAULT_PASSWORD;
    }

    private boolean isHostNetworkMode() {
        return Boolean.parseBoolean(System.getProperty("infinispan.service.network.mode.host", String.valueOf(false)));
    }
}

