/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.infinispan.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.infinispan.services.InfinispanLocalContainerInfraService;
import org.apache.camel.test.infra.infinispan.services.InfinispanRemoteInfraService;
import org.apache.camel.test.infra.infinispan.services.InfinispanService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class InfinispanServiceFactory {
    private InfinispanServiceFactory() {
    }

    public static SimpleTestServiceBuilder<InfinispanService> builder() {
        return new SimpleTestServiceBuilder("infinispan");
    }

    public static InfinispanService createService() {
        return (InfinispanService)InfinispanServiceFactory.builder().addLocalMapping(InfinispanLocalContainerService::new).addRemoteMapping(InfinispanRemoteService::new).build();
    }

    public static InfinispanService createSingletonInfinispanService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final InfinispanService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder serviceSimpleTestServiceBuilder = new SimpleTestServiceBuilder("infinispan");
            serviceSimpleTestServiceBuilder.addLocalMapping(() -> new SingletonInfinispanceService(new InfinispanLocalContainerService()));
            INSTANCE = (InfinispanService)serviceSimpleTestServiceBuilder.build();
        }
    }

    public static class InfinispanRemoteService
    extends InfinispanRemoteInfraService
    implements InfinispanService {
    }

    public static class InfinispanLocalContainerService
    extends InfinispanLocalContainerInfraService
    implements InfinispanService {
    }

    static class SingletonInfinispanceService
    extends SingletonService<InfinispanService>
    implements InfinispanService {
        public SingletonInfinispanceService(InfinispanService service) {
            this(service, "infinispan");
        }

        public SingletonInfinispanceService(InfinispanService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String username() {
            return ((InfinispanService)this.getService()).username();
        }

        @Override
        public String password() {
            return ((InfinispanService)this.getService()).password();
        }

        @Override
        public int port() {
            return ((InfinispanService)this.getService()).port();
        }

        @Override
        public String host() {
            return ((InfinispanService)this.getService()).host();
        }

        @Override
        public String getServiceAddress() {
            return ((InfinispanService)this.getService()).getServiceAddress();
        }

        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        public void afterAll(ExtensionContext extensionContext) {
        }
    }
}

