/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.nats.services;

import org.apache.camel.test.infra.nats.services.NatsLocalContainerService;
import org.apache.camel.test.infra.nats.services.NatsService;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class NatsLocalContainerAuthService
extends NatsLocalContainerService
implements NatsService {
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "password";

    @Override
    protected GenericContainer initContainer(String imageName, String containerName) {
        GenericContainer container = super.initContainer(imageName, containerName);
        container.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Server.*is.*ready.*", (int)1)).withCommand(new String[]{"-DV", "--user", USERNAME, "--pass", PASSWORD});
        return container;
    }

    @Override
    public void registerProperties() {
        super.registerProperties();
        System.setProperty("nats.access.username", USERNAME);
        System.setProperty("nats.access.password", PASSWORD);
    }

    @Override
    public String getServiceAddress() {
        return String.format("%s:%s@%s:%d", USERNAME, PASSWORD, this.getHost(), this.getPort());
    }
}

