/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.pinecone.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.pinecone.services.PineconeLocalContainerInfraService;
import org.apache.camel.test.infra.pinecone.services.PineconeRemoteInfraService;
import org.apache.camel.test.infra.pinecone.services.PineconeService;

public final class PineconeServiceFactory {
    private PineconeServiceFactory() {
    }

    public static SimpleTestServiceBuilder<PineconeService> builder() {
        return new SimpleTestServiceBuilder("pinecone");
    }

    public static PineconeService createService() {
        return (PineconeService)PineconeServiceFactory.builder().addLocalMapping(PineconeLocalContainerService::new).addRemoteMapping(PineconeRemoteService::new).build();
    }

    public static PineconeService createSingletonService() {
        return (PineconeService)PineconeServiceFactory.builder().addLocalMapping(() -> new SingletonPineconeService(new PineconeLocalContainerService(), "pinecone")).build();
    }

    public static class SingletonPineconeService
    extends SingletonService<PineconeService>
    implements PineconeService {
        public SingletonPineconeService(PineconeService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String getPineconeEndpointUrl() {
            return ((PineconeService)this.getService()).getPineconeEndpointUrl();
        }

        @Override
        public String getPineconeHost() {
            return ((PineconeService)this.getService()).getPineconeHost();
        }

        @Override
        public int getPineconePort() {
            return ((PineconeService)this.getService()).getPineconePort();
        }
    }

    public static class PineconeLocalContainerService
    extends PineconeLocalContainerInfraService
    implements PineconeService {
    }

    public static class PineconeRemoteService
    extends PineconeRemoteInfraService
    implements PineconeService {
    }
}

