/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.rabbitmq.services;

import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.rabbitmq.services.ConnectionProperties;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface RabbitMQService
extends TestService,
BeforeAllCallback,
AfterAllCallback {
    public ConnectionProperties connectionProperties();

    default public String getAmqpUrl() {
        ConnectionProperties properties = this.connectionProperties();
        return String.format("amqp://%s:%s", properties.hostname(), properties.port());
    }

    public int getHttpPort();

    public void initialize();

    public void shutdown();

    default public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.shutdown();
    }

    default public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.initialize();
    }
}

