/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.solr.services;

import java.util.function.Consumer;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.solr.services.SolrLocalContainerInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class SolrContainer
extends GenericContainer<SolrContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(SolrContainer.class);
    public static final String CONTAINER_NAME = "solr";
    public static final String SOLR_DFT_COLLECTION = "collection1";
    public static final String[] SOLR_CONTAINER_COMMANDS = new String[]{"solr-precreate", "collection1"};

    public SolrContainer() {
        super(LocalPropertyResolver.getProperty(SolrLocalContainerInfraService.class, (String)"solr.container"));
        ((SolrContainer)((SolrContainer)((SolrContainer)this.withNetworkAliases(new String[]{CONTAINER_NAME})).withEnv("SOLR_OPTS", "-Xss500k")).withExposedPorts(new Integer[]{8983})).waitingFor((WaitStrategy)Wait.forHttp((String)"/solr/admin/info/health"));
    }

    public SolrContainer(String imageName) {
        super(DockerImageName.parse((String)imageName));
    }

    public static SolrContainer initContainer(String networkAlias) {
        return (SolrContainer)((SolrContainer)((SolrContainer)((SolrContainer)((SolrContainer)((SolrContainer)((SolrContainer)((SolrContainer)new SolrContainer().withNetworkAliases(new String[]{networkAlias})).withEnv("SOLR_OPTS", "-Dsolr.environment=test,label=camel-solr-test-infra,color=sandybrown")).withEnv("GC_LOG_OPTS", "-verbose:")).withAccessToHost(true)).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG).withPrefix(CONTAINER_NAME))).withExposedPorts(new Integer[]{8983})).withCommand(SOLR_CONTAINER_COMMANDS)).waitingFor((WaitStrategy)Wait.forHttp((String)"/solr/collection1/admin/ping?docker-ping"));
    }
}

