/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.solr.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.solr.services.SolrContainer;
import org.apache.camel.test.infra.solr.services.SolrInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InfraService(service=SolrInfraService.class, description="Apache Solr is a Search Platform", serviceAlias={"solr"})
public class SolrLocalContainerInfraService
implements SolrInfraService,
ContainerService<SolrContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(SolrLocalContainerInfraService.class);
    private final SolrContainer container = SolrContainer.initContainer("solr");

    public void registerProperties() {
        System.setProperty("solr.host", this.getSolrHost());
        System.setProperty("solr.port", String.valueOf(this.getPort()));
    }

    public void initialize() {
        LOG.info("Trying to start solr container");
        this.container.withStartupAttempts(5);
        this.container.start();
        this.registerProperties();
        LOG.info("Solr instance running at {}", (Object)this.getSolrBaseUrl());
    }

    private String getSolrBaseUrl() {
        return String.format("http://%s/solr", this.getHttpHostAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Solr container");
        this.container.stop();
    }

    public SolrContainer getContainer() {
        return this.container;
    }

    @Override
    public String getSolrHost() {
        return this.container.getHost();
    }

    @Override
    public int getPort() {
        return this.container.getMappedPort(8983);
    }
}

