/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5.util;

import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.test.CamelRouteCoverageDumper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteCoverageDumperExtension {
    private static final Logger LOG = LoggerFactory.getLogger(RouteCoverageDumperExtension.class);
    private final ModelCamelContext context;

    public RouteCoverageDumperExtension(ModelCamelContext context) {
        this.context = context;
    }

    public void dumpRouteCoverage(Class<?> testClass, String currentTestName, long taken) throws Exception {
        ManagedCamelContextMBean managedCamelContext;
        String className = testClass.getSimpleName();
        String dir = "target/camel-route-coverage";
        String name = className + "-" + StringHelper.before((String)currentTestName, (String)"(") + ".xml";
        CamelRouteCoverageDumper routeCoverageDumper = new CamelRouteCoverageDumper();
        ManagedCamelContext mc = this.context != null ? (ManagedCamelContext)this.context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class) : null;
        ManagedCamelContextMBean managedCamelContextMBean = managedCamelContext = mc != null ? mc.getManagedCamelContext() : null;
        if (managedCamelContext == null) {
            LOG.warn("Cannot dump route coverage to file as JMX is not enabled. Add camel-management JAR as dependency and/or override useJmx() method to enable JMX in the unit test classes.");
        } else {
            routeCoverageDumper.dump(managedCamelContext, this.context, dir, name, this.getClass().getName(), currentTestName, taken);
        }
    }
}

