/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.main.junit5;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.test.CamelRouteCoverageDumper;
import org.apache.camel.test.junit5.TestSupport;
import org.apache.camel.test.main.junit5.CamelMainContext;
import org.apache.camel.test.main.junit5.CamelMainTest;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CamelMainExtension
implements Extension,
BeforeEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CamelMainExtension.class);
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CamelMainExtension.class});
    private static final String CONTEXT = "context";
    private static final String WATCH = "watch";
    private final CamelRouteCoverageDumper routeCoverageDumper = new CamelRouteCoverageDumper();

    CamelMainExtension() {
    }

    public void beforeEach(ExtensionContext context) {
        this.getContextStore(context).getOrComputeIfAbsent((Object)CONTEXT, k -> this.createCamelMainContextAndStart(context));
    }

    public void beforeTestExecution(ExtensionContext context) {
        context.getStore(NAMESPACE).put((Object)WATCH, (Object)new StopWatch());
        if (LOG.isInfoEnabled()) {
            Class requiredTestClass = context.getRequiredTestClass();
            String currentTestName = context.getDisplayName();
            LOG.info("********************************************************************************");
            LOG.info("Testing: {} ({})", (Object)currentTestName, (Object)requiredTestClass.getName());
            LOG.info("********************************************************************************");
        }
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        long time = ((StopWatch)context.getStore(NAMESPACE).remove((Object)WATCH, StopWatch.class)).taken();
        String currentTestName = context.getDisplayName();
        if (LOG.isInfoEnabled()) {
            Class requiredTestClass = context.getRequiredTestClass();
            LOG.info("********************************************************************************");
            LOG.info("Testing done: {} ({})", (Object)currentTestName, (Object)requiredTestClass.getName());
            LOG.info("Took: {} ({} millis)", (Object)TimeUtils.printDuration((long)time, (boolean)true), (Object)time);
            LOG.info("********************************************************************************");
        }
        this.dumpRouteCoverageIfNeeded(context, time, currentTestName);
    }

    private CamelMainContext createCamelMainContextAndStart(ExtensionContext context) {
        try {
            CamelMainContext camelMainContext = CamelMainContext.builder(context).useJmx(this.useJmx(context) || this.isRouteCoverageEnabled(context) || TestSupport.isCamelDebugPresent()).build();
            camelMainContext.start();
            return camelMainContext;
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private ExtensionContext.Store getContextStore(ExtensionContext context) {
        ExtensionContext sourceContext = context;
        if (context.getTestInstanceLifecycle().stream().anyMatch(lifecycle -> lifecycle.equals((Object)TestInstance.Lifecycle.PER_CLASS))) {
            sourceContext = (ExtensionContext)context.getParent().orElseThrow();
        }
        return sourceContext.getStore(NAMESPACE);
    }

    private void dumpRouteCoverageIfNeeded(ExtensionContext context, long time, String currentTestName) throws Exception {
        if (this.isRouteCoverageEnabled(context)) {
            ManagedCamelContextMBean managedCamelContext;
            Class requiredTestClass = context.getRequiredTestClass();
            String className = requiredTestClass.getName().substring(requiredTestClass.getPackageName().length() + 1);
            String dir = "target/camel-route-coverage";
            String name = String.format("%s-%s.xml", className, StringHelper.before((String)currentTestName, (String)"("));
            ModelCamelContext camelContext = ((CamelMainContext)this.getContextStore(context).get((Object)CONTEXT, CamelMainContext.class)).context();
            ManagedCamelContext mc = camelContext == null ? null : (ManagedCamelContext)camelContext.getExtension(ManagedCamelContext.class);
            ManagedCamelContextMBean managedCamelContextMBean = managedCamelContext = mc == null ? null : mc.getManagedCamelContext();
            if (managedCamelContext == null) {
                LOG.warn("Cannot dump route coverage to file as JMX is not enabled. Add camel-management JAR as dependency to enable JMX in the unit test classes.");
            } else {
                this.routeCoverageDumper.dump(managedCamelContext, camelContext, dir, name, requiredTestClass.getName(), currentTestName, time);
            }
        }
    }

    private boolean isRouteCoverageEnabled(ExtensionContext context) {
        return "true".equalsIgnoreCase(System.getProperty("CamelTestRouteCoverage", "false")) || context.getRequiredTestInstances().getAllInstances().get(0).getClass().getAnnotation(CamelMainTest.class).dumpRouteCoverage();
    }

    private boolean useJmx(ExtensionContext context) {
        return context.getRequiredTestInstances().getAllInstances().get(0).getClass().getAnnotation(CamelMainTest.class).useJmx();
    }
}

