/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.main.junit5;

import org.apache.camel.CamelContext;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.apache.camel.test.main.junit5.MainForTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CamelMainTestSupport
extends CamelTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CamelMainTestSupport.class);

    protected void configure(MainConfigurationProperties configuration) {
    }

    protected void bindToRegistryAfterInjections(Registry registry) throws Exception {
    }

    protected String getPropertyPlaceholderLocations() {
        String locations = this.getPropertyPlaceholderLocationsFromFileName();
        if (locations == null) {
            LOG.debug("Use the default property placeholder location");
            return "classpath:application.properties;optional=true";
        }
        LOG.debug("Use the following property placeholder locations: {}", (Object)locations);
        return locations;
    }

    protected String getPropertyPlaceholderFileName() {
        return null;
    }

    protected Class<?> getMainClass() {
        return null;
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        LOG.debug("Initialize the camel context as a Camel Main application");
        MainForTest main = new MainForTest();
        Class<?> mainClass = this.getMainClass();
        if (mainClass != null) {
            main.configure().withBasePackageScan(mainClass.getPackageName());
        }
        this.configure(main.configure());
        main.setPropertyPlaceholderLocations(this.getPropertyPlaceholderLocations());
        main.setOverrideProperties(this.useOverridePropertiesWithPropertiesComponent());
        main.init(context);
        return context;
    }

    protected void applyCamelPostProcessor() throws Exception {
        super.applyCamelPostProcessor();
        this.bindToRegistryAfterInjections(this.context.getRegistry());
    }

    private String getPropertyPlaceholderLocationsFromFileName() {
        String location = this.getPropertyPlaceholderFileName();
        if (location == null) {
            return null;
        }
        return String.format("classpath:%s/%s;optional=true,classpath:%s;optional=true", ((Object)((Object)this)).getClass().getPackageName().replace('.', '/'), location, location);
    }
}

