/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring.junit5;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.ExcludingPackageScanClassResolver;
import org.apache.camel.test.spring.junit5.CamelAnnotationsHandler;
import org.apache.camel.test.spring.junit5.CamelSpringTestHelper;
import org.apache.camel.test.spring.junit5.CamelSpringTestSupport;
import org.apache.camel.test.spring.junit5.ExcludeRoutes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.util.StringUtils;

public class CamelSpringTestContextLoader
extends AbstractContextLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringTestContextLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        Class<?> testClass = this.getTestClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading ApplicationContext for merged context configuration [{}].", (Object)mergedConfig);
        }
        try {
            GenericApplicationContext context = this.createContext(testClass, mergedConfig);
            this.prepareContext((ConfigurableApplicationContext)context, mergedConfig);
            this.loadBeanDefinitions(context, mergedConfig);
            AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)context);
            this.customizeContext((ConfigurableApplicationContext)context, mergedConfig);
            ApplicationContext applicationContext = this.loadContext(context, testClass);
            return applicationContext;
        }
        finally {
            CamelAnnotationsHandler.cleanup(testClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext loadContext(String ... locations) throws Exception {
        Class<?> testClass = this.getTestClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading ApplicationContext for locations [" + StringUtils.arrayToCommaDelimitedString((Object[])locations) + "].");
        }
        try {
            GenericApplicationContext context = this.createContext(testClass, null);
            this.loadBeanDefinitions(context, testClass, locations);
            ApplicationContext applicationContext = this.loadContext(context, testClass);
            return applicationContext;
        }
        finally {
            CamelAnnotationsHandler.cleanup(testClass);
        }
    }

    public String getResourceSuffix() {
        return "-context.xml";
    }

    protected ApplicationContext loadContext(GenericApplicationContext context, Class<?> testClass) throws Exception {
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)context);
        CamelAnnotationsHandler.handleDisableJmx((ConfigurableApplicationContext)context, testClass);
        CamelAnnotationsHandler.handleExcludeRoutes((ConfigurableApplicationContext)context, testClass);
        CamelAnnotationsHandler.handleUseOverridePropertiesWithPropertiesComponent((ConfigurableApplicationContext)context, testClass);
        SpringCamelContext.setNoStart((boolean)true);
        try {
            context.refresh();
            context.registerShutdownHook();
        }
        finally {
            SpringCamelContext.setNoStart((boolean)false);
        }
        CamelAnnotationsHandler.handleRouteCoverage((ConfigurableApplicationContext)context, testClass, s -> this.getTestMethod().getName());
        CamelAnnotationsHandler.handleProvidesBreakpoint((ConfigurableApplicationContext)context, testClass);
        CamelAnnotationsHandler.handleShutdownTimeout((ConfigurableApplicationContext)context, testClass);
        CamelAnnotationsHandler.handleMockEndpoints((ConfigurableApplicationContext)context, testClass);
        CamelAnnotationsHandler.handleMockEndpointsAndSkip((ConfigurableApplicationContext)context, testClass);
        CamelAnnotationsHandler.handleCamelContextStartup((ConfigurableApplicationContext)context, testClass);
        return context;
    }

    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        this.loadBeanDefinitions(context, mergedConfig.getTestClass(), mergedConfig.getLocations());
        new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)context).register(mergedConfig.getClasses());
    }

    protected void loadBeanDefinitions(GenericApplicationContext context, Class<?> clazz, String ... locations) {
        Map<String, String> props = CamelSpringTestSupport.getTranslationProperties(clazz);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
        for (String location : locations) {
            Resource r = reader.getResourceLoader().getResource(location);
            CamelSpringTestSupport.TranslatedResource t = new CamelSpringTestSupport.TranslatedResource(r, props);
            reader.loadBeanDefinitions((Resource)t);
        }
    }

    protected GenericApplicationContext createContext(Class<?> testClass, MergedContextConfiguration mergedConfig) {
        ApplicationContext parentContext = null;
        GenericApplicationContext routeExcludingContext = null;
        if (mergedConfig != null) {
            parentContext = mergedConfig.getParentApplicationContext();
        }
        if (testClass.isAnnotationPresent(ExcludeRoutes.class)) {
            Object[] excludedClasses = testClass.getAnnotation(ExcludeRoutes.class).value();
            if (excludedClasses.length > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting up package scanning excluded classes as ExcludeRoutes annotation was found. Excluding [" + StringUtils.arrayToCommaDelimitedString((Object[])excludedClasses) + "].");
                }
                routeExcludingContext = parentContext == null ? new GenericApplicationContext() : new GenericApplicationContext(parentContext);
                routeExcludingContext.registerBeanDefinition("excludingResolver", (BeanDefinition)new RootBeanDefinition(ExcludingPackageScanClassResolver.class));
                routeExcludingContext.refresh();
                ExcludingPackageScanClassResolver excludingResolver = (ExcludingPackageScanClassResolver)routeExcludingContext.getBean("excludingResolver", ExcludingPackageScanClassResolver.class);
                List<Object> excluded = Arrays.asList(excludedClasses);
                excludingResolver.setExcludedClasses(new HashSet<Object>(excluded));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Not enabling package scanning excluded classes as ExcludeRoutes annotation was found but no classes were excluded.");
            }
        }
        GenericApplicationContext context = routeExcludingContext != null ? new GenericApplicationContext(routeExcludingContext) : (parentContext != null ? new GenericApplicationContext(parentContext) : new GenericApplicationContext());
        return context;
    }

    protected Class<?> getTestClass() {
        return CamelSpringTestHelper.getTestClass();
    }

    protected Method getTestMethod() {
        return CamelSpringTestHelper.getTestMethod();
    }
}

