/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit4;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.test.junit4.TestSupport;
import org.apache.camel.util.CamelContextHelper;
import org.junit.After;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CamelTestSupport
extends TestSupport {
    protected CamelContext context;
    protected ProducerTemplate template;
    protected ConsumerTemplate consumer;
    private boolean useRouteBuilder = true;
    private Service camelContextService;

    public boolean isUseRouteBuilder() {
        return this.useRouteBuilder;
    }

    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
    }

    public Service getCamelContextService() {
        return this.camelContextService;
    }

    public void setCamelContextService(Service camelContextService) {
        this.camelContextService = camelContextService;
    }

    @Before
    public void setUp() throws Exception {
        this.context = this.createCamelContext();
        this.assertValidContext(this.context);
        this.template = this.context.createProducerTemplate();
        this.consumer = this.context.createConsumerTemplate();
        this.postProcessTest();
        if (this.isUseRouteBuilder()) {
            RouteBuilder[] builders;
            for (RouteBuilder builder : builders = this.createRouteBuilders()) {
                this.log.debug((Object)("Using created route builder: " + builder));
                this.context.addRoutes((RoutesBuilder)builder);
            }
            this.startCamelContext();
            this.log.debug((Object)("Routing Rules are: " + this.context.getRoutes()));
        } else {
            this.log.debug((Object)("Using route builder from the created context: " + this.context));
        }
        this.log.debug((Object)("Routing Rules are: " + this.context.getRoutes()));
    }

    @After
    public void tearDown() throws Exception {
        this.log.debug((Object)"tearDown test ");
        if (this.consumer != null) {
            this.consumer.stop();
        }
        if (this.template != null) {
            this.template.stop();
        }
        this.stopCamelContext();
    }

    protected void postProcessTest() throws Exception {
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setCamelContext(this.context);
        processor.postProcessBeforeInitialization((Object)this, "this");
    }

    protected void stopCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.stop();
        } else if (this.context != null) {
            this.context.stop();
        }
    }

    protected void startCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.start();
        } else if (this.context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            this.context.start();
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        return new DefaultCamelContext((Registry)this.createRegistry());
    }

    protected JndiRegistry createRegistry() throws Exception {
        return new JndiRegistry(this.createJndiContext());
    }

    protected Context createJndiContext() throws Exception {
        Properties properties = new Properties();
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jndi.properties");
        if (in != null) {
            this.log.debug((Object)"Using jndi.properties from classpath root");
            properties.load(in);
        } else {
            properties.put("java.naming.factory.initial", "org.apache.camel.util.jndi.CamelInitialContextFactory");
        }
        return new InitialContext(new Hashtable<Object, Object>(properties));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{this.createRouteBuilder()};
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return CamelTestSupport.resolveMandatoryEndpoint(this.context, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return CamelTestSupport.resolveMandatoryEndpoint(this.context, uri, endpointType);
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
    }

    protected void sendBody(String endpointUri, final Object body) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
            }
        });
    }

    protected void sendBody(String endpointUri, final Object body, final Map<String, Object> headers) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                for (Map.Entry entry : headers.entrySet()) {
                    in.setHeader((String)entry.getKey(), entry.getValue());
                }
            }
        });
    }

    protected void sendBodies(String endpointUri, Object ... bodies) {
        for (Object body : bodies) {
            this.sendBody(endpointUri, body);
        }
    }

    protected Exchange createExchangeWithBody(Object body) {
        return this.createExchangeWithBody(this.context, body);
    }

    protected void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        Language language = this.assertResolveLanguage(languageName);
        Expression expression = language.createExpression(expressionText);
        CamelTestSupport.assertNotNull((String)("No Expression could be created for text: " + expressionText + " language: " + language), (Object)expression);
        CamelTestSupport.assertExpression(expression, exchange, expectedValue);
    }

    protected void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        Language language = this.assertResolveLanguage(languageName);
        Predicate predicate = language.createPredicate(expressionText);
        CamelTestSupport.assertNotNull((String)("No Predicate could be created for text: " + expressionText + " language: " + language), (Object)predicate);
        CamelTestSupport.assertPredicate(predicate, exchange, expected);
    }

    protected Language assertResolveLanguage(String languageName) {
        Language language = this.context.resolveLanguage(languageName);
        CamelTestSupport.assertNotNull((String)("No language found for name: " + languageName), (Object)language);
        return language;
    }

    protected void assertMockEndpointsSatisfied() throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.context);
    }

    protected void assertValidContext(CamelContext context) {
        CamelTestSupport.assertNotNull((String)"No context found!", (Object)context);
    }

    protected <T> List<T> getSingletonEndpoints(Class<T> type) {
        return CamelContextHelper.getSingletonEndpoints((CamelContext)this.context, type);
    }

    protected <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        Endpoint endpoint = this.context.getEndpoint(uri, type);
        CamelTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return (T)endpoint;
    }

    protected Endpoint getMandatoryEndpoint(String uri) {
        Endpoint endpoint = this.context.getEndpoint(uri);
        CamelTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return endpoint;
    }

    protected void disableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "true");
    }

    protected void enableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "false");
    }
}

