/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvailablePortFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AvailablePortFinder.class);

    private AvailablePortFinder() {
    }

    public static int getNextAvailable() {
        return AvailablePortFinder.probePort(0);
    }

    public static int getNextAvailable(int fromPort, int toPort) {
        for (int i = fromPort; i <= toPort; ++i) {
            try {
                return AvailablePortFinder.probePort(i);
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
        }
        throw new IllegalStateException("Cannot find free port");
    }

    private static int probePort(int port) {
        int n;
        ServerSocket ss = new ServerSocket();
        try {
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress((InetAddress)null, port), 1);
            int probedPort = ss.getLocalPort();
            LOG.info("Available port is -> {}", (Object)probedPort);
            n = probedPort;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot find free port", e);
            }
        }
        ss.close();
        return n;
    }
}

