/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.testcontainers;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;

@Deprecated
public final class Containers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Containers.class);

    private Containers() {
    }

    public static void start(List<GenericContainer<?>> containers, Network network, long timeout) throws Exception {
        CountDownLatch latch = new CountDownLatch(containers.size());
        for (GenericContainer<?> container : containers) {
            if (ObjectHelper.isEmpty((Object)container.getNetworkAliases())) {
                throw new IllegalStateException("Container should have at least a network alias");
            }
            if (network != null) {
                container.withNetwork(network);
            }
            container.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER).withPrefix(container.getNetworkAliases().stream().collect(Collectors.joining(","))));
            new Thread(() -> {
                container.start();
                latch.countDown();
            }).start();
        }
        latch.await(timeout, TimeUnit.SECONDS);
    }

    public static void stop(List<GenericContainer<?>> containers, long timeout) throws Exception {
        CountDownLatch latch = new CountDownLatch(containers.size());
        for (GenericContainer<?> container : containers) {
            new Thread(() -> {
                container.stop();
                latch.countDown();
            }).start();
        }
        latch.await(timeout, TimeUnit.SECONDS);
    }

    public static GenericContainer<?> lookup(List<GenericContainer<?>> containers, String containerName) {
        for (GenericContainer<?> container : containers) {
            if (!container.getNetworkAliases().contains(containerName)) continue;
            return container;
        }
        throw new IllegalArgumentException("No container with name " + containerName + " found");
    }
}

