/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.testng;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.spi.Language;
import org.apache.camel.testng.ExchangeTestSupport;

public abstract class LanguageTestSupport
extends ExchangeTestSupport {
    protected abstract String getLanguageName();

    protected void assertPredicate(String expression) {
        this.assertPredicate(this.exchange, expression, true);
    }

    protected void assertPredicateFails(String expression) {
        this.assertPredicate(this.exchange, expression, false);
    }

    protected void assertPredicate(String expression, boolean expected) {
        this.assertPredicate(this.exchange, expression, expected);
    }

    protected void assertPredicate(Exchange exchange, String expression, boolean expected) {
        this.assertPredicate(this.getLanguageName(), expression, exchange, expected);
    }

    protected void assertExpression(Exchange exchange, String expressionText, Object expectedValue) {
        this.assertExpression(exchange, this.getLanguageName(), expressionText, expectedValue);
    }

    protected void assertExpression(String expressionText, Object expectedValue) {
        this.assertExpression(this.exchange, expressionText, expectedValue);
    }

    protected void assertExpression(String expressionText, String expectedValue, String orThisExpectedValue) {
        Language language = this.assertResolveLanguage(this.getLanguageName());
        Expression expression = language.createExpression(expressionText);
        LanguageTestSupport.assertNotNull((Object)expression, (String)("No Expression could be created for text: " + expressionText + " language: " + language));
        Object value = expectedValue != null ? expression.evaluate(this.exchange, expectedValue.getClass()) : expression.evaluate(this.exchange, Object.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Evaluated expression: " + expression + " on exchange: " + this.exchange + " result: " + value);
        }
        LanguageTestSupport.assertTrue((expectedValue.equals(value) || orThisExpectedValue.equals(value) ? 1 : 0) != 0, (String)("Expression: " + expression + " on Exchange: " + this.exchange));
    }
}

