/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.maven;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.tooling.maven.DefaultRepositoryResolver;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.tooling.maven.MavenDownloader;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.maven.MavenResolutionException;
import org.apache.camel.tooling.maven.RemoteArtifactDownloadListener;
import org.apache.camel.tooling.maven.RepositoryResolver;
import org.apache.camel.tooling.maven.support.DIRegistry;
import org.apache.camel.util.StopWatch;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultModelCacheFactory;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.ModelCacheFactory;
import org.apache.maven.repository.internal.PluginsMetadataGeneratorFactory;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.settings.io.DefaultSettingsReader;
import org.apache.maven.settings.io.DefaultSettingsWriter;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.settings.validation.DefaultSettingsValidator;
import org.apache.maven.settings.validation.SettingsValidator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.aether.internal.impl.DefaultFileProcessor;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.aether.internal.impl.DefaultLocalPathComposer;
import org.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.internal.impl.DefaultOfflineController;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultRepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.DefaultTrackingFileManager;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha256ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector;
import org.eclipse.aether.internal.impl.collect.df.DfDependencyCollector;
import org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager;
import org.eclipse.aether.internal.impl.synccontext.DefaultSyncContextFactory;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NameMappers;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactoryImpl;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import org.eclipse.aether.named.providers.NoopNamedLockFactory;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.ChecksumExtractor;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.transport.http.Nexus2ChecksumExtractor;
import org.eclipse.aether.transport.http.XChecksumChecksumExtractor;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class MavenDownloaderImpl
extends ServiceSupport
implements MavenDownloader {
    public static final Logger LOG = LoggerFactory.getLogger(MavenDownloader.class);
    public static final String MAVEN_CENTRAL_REPO = "https://repo1.maven.org/maven2";
    public static final String APACHE_SNAPSHOT_REPO = "https://repository.apache.org/snapshots";
    private static final RepositoryPolicy POLICY_DEFAULT = new RepositoryPolicy(true, "never", "warn");
    private static final RepositoryPolicy POLICY_FRESH = new RepositoryPolicy(true, "always", "warn");
    private static final RepositoryPolicy POLICY_DISABLED = new RepositoryPolicy(false, "never", "ignore");
    private RepositoryResolver repositoryResolver;
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private RemoteRepository centralRepository;
    private RemoteRepository centralResolutionRepository;
    private RemoteRepository apacheSnapshotsRepository;
    private RemoteRepository apacheSnapshotsResolutionRepository;
    private RepositoryPolicy defaultPolicy;
    private DIRegistry registry;
    private String mavenSettings;
    private String mavenSettingsSecurity;
    private String repos;
    private boolean fresh;
    private RemoteArtifactDownloadListener remoteArtifactDownloadListener;
    private boolean apacheSnapshotsIncluded;
    private AtomicInteger customRepositoryCounter = new AtomicInteger(1);
    private Settings settings;

    public MavenDownloaderImpl() {
    }

    public MavenDownloaderImpl(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, Settings settings) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBuild() {
        Settings settings;
        this.repositoryResolver = new DefaultRepositoryResolver();
        this.repositoryResolver.build();
        this.registry = new DIRegistry();
        Properties systemProperties = new Properties();
        Properties properties = System.getProperties();
        synchronized (properties) {
            systemProperties.putAll((Map<?, ?>)System.getProperties());
        }
        this.validateMavenSettingsLocations();
        if (this.repositorySystem == null) {
            this.repositorySystem = this.configureRepositorySystem(this.registry, systemProperties, this.mavenSettingsSecurity);
        }
        Settings settings2 = settings = this.settings == null ? this.mavenConfiguration(this.registry, this.repositorySystem, systemProperties, this.mavenSettings) : this.settings;
        if (this.repositorySystemSession == null) {
            this.repositorySystemSession = this.configureRepositorySystemSession(this.registry, systemProperties, settings, new File(settings.getLocalRepository()));
        }
        this.defaultPolicy = this.fresh ? POLICY_FRESH : POLICY_DEFAULT;
        List<RemoteRepository> originalRepositories = this.configureDefaultRepositories(settings);
        this.remoteRepositories.addAll(this.repositorySystem.newResolutionRepositories(this.repositorySystemSession, originalRepositories));
        this.centralResolutionRepository = this.remoteRepositories.get(0);
        if (!this.apacheSnapshotsIncluded) {
            this.apacheSnapshotsResolutionRepository = (RemoteRepository)this.repositorySystem.newResolutionRepositories(this.repositorySystemSession, Collections.singletonList(this.apacheSnapshotsRepository)).get(0);
        }
    }

    protected void doInit() {
    }

    protected void doStop() throws Exception {
        if (this.registry != null) {
            this.registry.close();
        }
    }

    @Override
    public void setRemoteArtifactDownloadListener(RemoteArtifactDownloadListener remoteArtifactDownloadListener) {
        this.remoteArtifactDownloadListener = remoteArtifactDownloadListener;
    }

    @Override
    public List<MavenArtifact> resolveArtifacts(List<String> dependencyGAVs, Set<String> extraRepositories, boolean transitively, boolean useApacheSnapshots) throws MavenResolutionException {
        ArtifactTypeRegistry artifactTypeRegistry = this.repositorySystemSession.getArtifactTypeRegistry();
        ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>(dependencyGAVs.size());
        CollectRequest collectRequest = new CollectRequest();
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(this.remoteRepositories);
        if (extraRepositories != null) {
            ArrayList<RemoteRepository> extraRemoteRepositories = new ArrayList<RemoteRepository>();
            this.configureRepositories(extraRemoteRepositories, extraRepositories);
            repositories.addAll(this.repositorySystem.newResolutionRepositories(this.repositorySystemSession, (List)extraRemoteRepositories));
        }
        if (useApacheSnapshots && !this.apacheSnapshotsIncluded) {
            repositories.add(this.apacheSnapshotsResolutionRepository);
        }
        collectRequest.setRepositories(repositories);
        for (String depId : dependencyGAVs) {
            ArtifactRequest ar = new ArtifactRequest();
            ar.setRepositories(repositories);
            MavenGav gav = MavenGav.parseGav(depId);
            DefaultArtifact artifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), gav.getClassifier(), gav.getPackaging(), gav.getVersion(), artifactTypeRegistry.get(gav.getPackaging()));
            ar.setArtifact((Artifact)artifact);
            requests.add(ar);
            Dependency dependency = new Dependency(ar.getArtifact(), "compile", Boolean.valueOf(false));
            collectRequest.addDependency(dependency);
        }
        if (this.remoteArtifactDownloadListener != null && this.repositorySystemSession instanceof DefaultRepositorySystemSession) {
            DefaultRepositorySystemSession drss = (DefaultRepositorySystemSession)this.repositorySystemSession;
            drss.setRepositoryListener((RepositoryListener)new AbstractRepositoryListener(){
                private final StopWatch watch = new StopWatch();

                public void artifactDownloading(RepositoryEvent event) {
                    this.watch.restart();
                }

                public void artifactDownloaded(RepositoryEvent event) {
                    if (event.getArtifact() != null) {
                        Artifact a = event.getArtifact();
                        ArtifactRepository ar = event.getRepository();
                        String url = ar instanceof RemoteRepository ? ((RemoteRepository)ar).getUrl() : null;
                        String id = ar != null ? ar.getId() : null;
                        long elapsed = this.watch.takenAndRestart();
                        String version = a.isSnapshot() ? a.getBaseVersion() : a.getVersion();
                        MavenDownloaderImpl.this.remoteArtifactDownloadListener.artifactDownloaded(a.getGroupId(), a.getArtifactId(), version, id, url, elapsed);
                    }
                }
            });
        }
        if (transitively) {
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (DependencyFilter)new AcceptAllDependencyFilter());
            try {
                DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
                return dependencyResult.getArtifactResults().stream().map(dr -> {
                    Artifact a = dr.getArtifact();
                    MavenGav gav = MavenGav.fromCoordinates(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getExtension(), a.getClassifier());
                    return new MavenArtifact(gav, a.getFile());
                }).collect(Collectors.toList());
            }
            catch (DependencyResolutionException e) {
                MavenResolutionException mre = new MavenResolutionException(e.getMessage(), e);
                repositories.forEach(r -> mre.getRepositories().add(r.getUrl()));
                throw mre;
            }
        }
        try {
            List artifactResults = this.repositorySystem.resolveArtifacts(this.repositorySystemSession, requests);
            return artifactResults.stream().map(dr -> {
                Artifact a = dr.getArtifact();
                MavenGav gav = MavenGav.fromCoordinates(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getExtension(), a.getClassifier());
                return new MavenArtifact(gav, a.getFile());
            }).collect(Collectors.toList());
        }
        catch (ArtifactResolutionException e) {
            MavenResolutionException mre = new MavenResolutionException(e.getMessage(), e);
            repositories.forEach(r -> mre.getRepositories().add(r.getUrl()));
            throw mre;
        }
    }

    @Override
    public List<MavenGav> resolveAvailableVersions(String groupId, String artifactId, String repository) throws MavenResolutionException {
        MetadataRequest req = new MetadataRequest();
        ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
        try {
            if (repository == null) {
                req.setRepository(this.centralResolutionRepository);
            } else {
                String id = "custom" + this.customRepositoryCounter.getAndIncrement();
                RemoteRepository custom = new RemoteRepository.Builder(id, "default", repository).setReleasePolicy(this.defaultPolicy).setSnapshotPolicy(this.defaultPolicy).build();
                List customResolutionRepository = this.repositorySystem.newResolutionRepositories(this.repositorySystemSession, Collections.singletonList(custom));
                req.setRepository((RemoteRepository)customResolutionRepository.get(0));
            }
            req.setFavorLocalRepository(false);
            req.setMetadata((org.eclipse.aether.metadata.Metadata)new DefaultMetadata(groupId, artifactId, "maven-metadata.xml", Metadata.Nature.RELEASE));
            List result = this.repositorySystem.resolveMetadata(this.repositorySystemSession, List.of(req));
            for (MetadataResult mr : result) {
                File f;
                if (!mr.isResolved() || mr.getMetadata().getFile() == null || !(f = mr.getMetadata().getFile()).exists() || !f.isFile()) continue;
                MetadataXpp3Reader reader = new MetadataXpp3Reader();
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));){
                    Metadata md = reader.read((InputStream)is);
                    List versions = md.getVersioning().getVersions();
                    if (versions == null) continue;
                    for (String v : versions) {
                        if (v == null) continue;
                        gavs.add(MavenGav.fromCoordinates(groupId, artifactId, v, null, null));
                    }
                }
            }
            return gavs;
        }
        catch (Exception e) {
            String msg = "Cannot resolve available versions in " + req.getRepository().getUrl();
            MavenResolutionException mre = new MavenResolutionException(msg, e);
            mre.getRepositories().add(req.getRepository().getUrl());
            throw mre;
        }
    }

    @Override
    public MavenDownloader customize(String localRepository, int connectTimeout, int requestTimeout) {
        MavenDownloaderImpl copy = new MavenDownloaderImpl();
        copy.repositorySystem = this.repositorySystem;
        copy.remoteRepositories.addAll(this.remoteRepositories);
        copy.apacheSnapshotsRepository = this.apacheSnapshotsRepository;
        copy.apacheSnapshotsResolutionRepository = this.apacheSnapshotsResolutionRepository;
        copy.defaultPolicy = this.defaultPolicy;
        copy.registry = this.registry;
        copy.mavenSettings = this.mavenSettings;
        copy.mavenSettingsSecurity = this.mavenSettingsSecurity;
        copy.repos = this.repos;
        copy.fresh = this.fresh;
        copy.apacheSnapshotsIncluded = this.apacheSnapshotsIncluded;
        copy.customRepositoryCounter = this.customRepositoryCounter;
        copy.repositoryResolver = this.repositoryResolver;
        LocalRepositoryManagerFactory lrmFactory = this.registry.lookupByClass(LocalRepositoryManagerFactory.class);
        DefaultRepositorySystemSession rssCopy = new DefaultRepositorySystemSession(this.repositorySystemSession);
        rssCopy.setConfigProperty("aether.connector.connectTimeout", (Object)connectTimeout);
        rssCopy.setConfigProperty("aether.connector.requestTimeout", (Object)requestTimeout);
        try {
            rssCopy.setLocalRepositoryManager(lrmFactory.newInstance((RepositorySystemSession)rssCopy, new LocalRepository(localRepository)));
        }
        catch (NoLocalRepositoryManagerException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        copy.repositorySystemSession = rssCopy;
        return copy;
    }

    private void validateMavenSettingsLocations() {
        if (this.mavenSettingsSecurity != null && !new File(this.mavenSettingsSecurity).isFile()) {
            LOG.warn("Can't access {}. Skipping Maven settings-security.xml configuration.", (Object)this.mavenSettingsSecurity);
            this.mavenSettingsSecurity = null;
        }
        boolean skip = false;
        if ("false".equalsIgnoreCase(this.mavenSettings)) {
            this.mavenSettings = null;
            this.mavenSettingsSecurity = null;
            skip = true;
        } else if (this.mavenSettings == null) {
            String m2settings = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "settings.xml";
            if (new File(m2settings).isFile()) {
                this.mavenSettings = m2settings;
            }
        } else {
            if (!new File(this.mavenSettings).isFile()) {
                LOG.warn("Can't access {}. Skipping Maven settings.xml configuration.", (Object)this.mavenSettings);
            }
            this.mavenSettings = null;
        }
        if (!skip) {
            if (this.mavenSettingsSecurity == null) {
                String m2settingsSecurity = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "settings-security.xml";
                if (new File(m2settingsSecurity).isFile()) {
                    this.mavenSettingsSecurity = m2settingsSecurity;
                }
            } else {
                if (!new File(this.mavenSettingsSecurity).isFile()) {
                    LOG.warn("Can't access {}. Skipping Maven settings-settings.xml configuration.", (Object)this.mavenSettingsSecurity);
                }
                this.mavenSettingsSecurity = null;
            }
        }
    }

    RepositorySystem configureRepositorySystem(DIRegistry registry, Properties systemProperties, String settingsSecurityLocation) {
        MavenDownloaderImpl.basicRepositorySystemConfiguration(registry);
        MavenDownloaderImpl.transportConfiguration(registry, systemProperties);
        MavenDownloaderImpl.settingsConfiguration(registry, settingsSecurityLocation);
        return registry.lookupByClass(RepositorySystem.class);
    }

    private static void basicRepositorySystemConfiguration(DIRegistry registry) {
        registry.bind(RepositorySystem.class, DefaultRepositorySystem.class);
        registry.bind(VersionResolver.class, DefaultVersionResolver.class);
        registry.bind(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        registry.bind(ArtifactResolver.class, DefaultArtifactResolver.class);
        registry.bind(MetadataResolver.class, DefaultMetadataResolver.class);
        registry.bind(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        registry.bind(DependencyCollector.class, DefaultDependencyCollector.class);
        registry.bind(Installer.class, DefaultInstaller.class);
        registry.bind(Deployer.class, DefaultDeployer.class);
        registry.bind(LocalRepositoryProvider.class, DefaultLocalRepositoryProvider.class);
        registry.bind(SyncContextFactory.class, DefaultSyncContextFactory.class);
        registry.bind(RemoteRepositoryManager.class, DefaultRemoteRepositoryManager.class);
        registry.bind(RepositoryEventDispatcher.class, DefaultRepositoryEventDispatcher.class);
        registry.bind(FileProcessor.class, DefaultFileProcessor.class);
        registry.bind(UpdateCheckManager.class, DefaultUpdateCheckManager.class);
        registry.bind(RepositoryConnectorProvider.class, DefaultRepositoryConnectorProvider.class);
        registry.bind(OfflineController.class, DefaultOfflineController.class);
        registry.bind("modelBuilder", ModelBuilder.class, new DefaultModelBuilderFactory().newInstance());
        registry.bind(DependencyCollectorDelegate.class, DfDependencyCollector.class);
        registry.bind(DependencyCollectorDelegate.class, BfDependencyCollector.class);
        registry.bind(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        registry.bind(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        registry.bind(MetadataGeneratorFactory.class, PluginsMetadataGeneratorFactory.class);
        registry.bind(LocalRepositoryManagerFactory.class, EnhancedLocalRepositoryManagerFactory.class);
        registry.bind(NamedLockFactoryAdapterFactory.class, NamedLockFactoryAdapterFactoryImpl.class);
        registry.bind(UpdatePolicyAnalyzer.class, DefaultUpdatePolicyAnalyzer.class);
        registry.bind(ChecksumPolicyProvider.class, DefaultChecksumPolicyProvider.class);
        registry.bind(TrackingFileManager.class, DefaultTrackingFileManager.class);
        registry.bind(NamedLockFactory.class, FileLockNamedLockFactory.class);
        registry.bind(NamedLockFactory.class, LocalReadWriteLockNamedLockFactory.class);
        registry.bind(NamedLockFactory.class, NoopNamedLockFactory.class);
        registry.bind(NamedLockFactory.class, LocalSemaphoreNamedLockFactory.class);
        registry.bind("gav", NameMapper.class, NameMappers.gavNameMapper());
        registry.bind("static", NameMapper.class, NameMappers.staticNameMapper());
        registry.bind("discriminating", NameMapper.class, NameMappers.discriminatingNameMapper());
        registry.bind("file-gav", NameMapper.class, NameMappers.fileGavNameMapper());
        registry.bind("file-hgav", NameMapper.class, NameMappers.fileHashingGavNameMapper());
        registry.bind(LocalPathComposer.class, DefaultLocalPathComposer.class);
        registry.bind(LocalPathPrefixComposerFactory.class, DefaultLocalPathPrefixComposerFactory.class);
        registry.bind(RemoteRepositoryFilterManager.class, DefaultRemoteRepositoryFilterManager.class);
        registry.bind(RepositorySystemLifecycle.class, DefaultRepositorySystemLifecycle.class);
        registry.bind(ModelCacheFactory.class, DefaultModelCacheFactory.class);
    }

    private static void transportConfiguration(DIRegistry registry, Properties systemProperties) {
        registry.bind(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        registry.bind(TransporterProvider.class, DefaultTransporterProvider.class);
        registry.bind(TransporterFactory.class, FileTransporterFactory.class);
        registry.bind(TransporterFactory.class, HttpTransporterFactory.class);
        registry.bind(ChecksumExtractor.class, Nexus2ChecksumExtractor.class);
        registry.bind(ChecksumExtractor.class, XChecksumChecksumExtractor.class);
        registry.bind(RepositoryLayoutProvider.class, DefaultRepositoryLayoutProvider.class);
        registry.bind(RepositoryLayoutFactory.class, Maven2RepositoryLayoutFactory.class);
        registry.bind(ChecksumAlgorithmFactorySelector.class, DefaultChecksumAlgorithmFactorySelector.class);
        registry.bind(ChecksumAlgorithmFactory.class, Md5ChecksumAlgorithmFactory.class);
        registry.bind(ChecksumAlgorithmFactory.class, Sha1ChecksumAlgorithmFactory.class);
        registry.bind(ChecksumAlgorithmFactory.class, Sha256ChecksumAlgorithmFactory.class);
        registry.bind(ChecksumAlgorithmFactory.class, Sha512ChecksumAlgorithmFactory.class);
    }

    private static void settingsConfiguration(DIRegistry registry, String localSettingsSecurity) {
        DefaultSecDispatcher securityDispatcher = new DefaultSecDispatcher((PlexusCipher)new DefaultPlexusCipher());
        securityDispatcher.setConfigurationFile(localSettingsSecurity);
        registry.bind("securityDispatcher", SecDispatcher.class, securityDispatcher);
        registry.bind(SettingsDecrypter.class, DefaultSettingsDecrypter.class);
        registry.bind(SettingsReader.class, DefaultSettingsReader.class);
        registry.bind(SettingsWriter.class, DefaultSettingsWriter.class);
        registry.bind(SettingsValidator.class, DefaultSettingsValidator.class);
        registry.bind(SettingsBuilder.class, DefaultSettingsBuilder.class);
    }

    Settings mavenConfiguration(DIRegistry registry, RepositorySystem repositorySystem, Properties systemProperties, String mavenSettings) {
        Comparable<File> m2Repository;
        Settings settings;
        SettingsBuilder settingsBuilder = registry.lookupByClass(SettingsBuilder.class);
        DefaultSettingsBuildingRequest sbRequest = new DefaultSettingsBuildingRequest();
        sbRequest.setSystemProperties(systemProperties);
        if (mavenSettings != null) {
            sbRequest.setUserSettingsFile(new File(mavenSettings));
        }
        try {
            SettingsBuildingResult sbResult = settingsBuilder.build((SettingsBuildingRequest)sbRequest);
            settings = sbResult.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            LOG.warn("Problem reading settings file {}: {}. Falling back to defaults.", new Object[]{mavenSettings, e.getMessage(), e});
            settings = new Settings();
        }
        String localRepository = System.getProperty("maven.repo.local");
        if (localRepository == null || localRepository.isBlank()) {
            localRepository = settings.getLocalRepository();
        }
        if (localRepository == null || localRepository.isBlank()) {
            m2Repository = Paths.get(System.getProperty("user.home"), ".m2/repository");
            if (!m2Repository.toFile().isDirectory()) {
                m2Repository = Paths.get(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
                m2Repository.toFile().mkdirs();
            }
            localRepository = m2Repository.toString();
        }
        m2Repository = new File(localRepository);
        settings.setLocalRepository(((File)m2Repository).getAbsolutePath());
        SettingsDecrypter decrypter = registry.lookupByClass(SettingsDecrypter.class);
        DefaultSettingsDecryptionRequest sdRequest = new DefaultSettingsDecryptionRequest(settings);
        SettingsDecryptionResult sdResult = decrypter.decrypt((SettingsDecryptionRequest)sdRequest);
        settings.setProxies(sdResult.getProxies());
        settings.setServers(sdResult.getServers());
        for (Map.Entry entry : settings.getProfilesAsMap().entrySet()) {
            String name = (String)entry.getKey();
            Profile profile = (Profile)entry.getValue();
            if (profile.getActivation() == null || !profile.getActivation().isActiveByDefault()) continue;
            settings.getActiveProfiles().add(name);
        }
        return settings;
    }

    RepositorySystemSession configureRepositorySystemSession(DIRegistry registry, Properties systemProperties, Settings settings, File localRepository) {
        JreProxySelector proxySelector;
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        if (settings.getProxies().isEmpty()) {
            proxySelector = new JreProxySelector();
        } else {
            proxySelector = new DefaultProxySelector();
            for (Proxy proxy : settings.getProxies()) {
                if (!proxy.isActive()) continue;
                String nonProxyHosts = proxy.getNonProxyHosts();
                AuthenticationBuilder builder = new AuthenticationBuilder();
                if (proxy.getUsername() != null) {
                    builder.addUsername(proxy.getUsername());
                    builder.addPassword(proxy.getPassword());
                }
                org.eclipse.aether.repository.Proxy proxyConfig = new org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), builder.build());
                ((DefaultProxySelector)proxySelector).add(proxyConfig, nonProxyHosts);
            }
        }
        HashMap<Object, Object> serverConfigurations = new HashMap<Object, Object>();
        DefaultAuthenticationSelector baseAuthenticationSelector = new DefaultAuthenticationSelector();
        ConservativeAuthenticationSelector authenticationSelector = new ConservativeAuthenticationSelector((AuthenticationSelector)baseAuthenticationSelector);
        int connectTimeout = 10000;
        int requestTimeout = 1800000;
        for (Object server : settings.getServers()) {
            Xpp3Dom requestTimeoutNode;
            Authentication auth = new AuthenticationBuilder().addPrivateKey(server.getPrivateKey(), server.getPassphrase()).addUsername(server.getUsername()).addPassword(server.getPassword()).build();
            baseAuthenticationSelector.add(server.getId(), auth);
            if (server.getFilePermissions() != null) {
                serverConfigurations.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            }
            if (server.getDirectoryPermissions() != null) {
                serverConfigurations.put("aether.connector.perms.dirMode." + server.getId(), server.getFilePermissions());
            }
            if (!(server.getConfiguration() instanceof Xpp3Dom)) continue;
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            Xpp3Dom serverConfig = (Xpp3Dom)server.getConfiguration();
            Xpp3Dom httpHeaders = serverConfig.getChild("httpHeaders");
            if (httpHeaders != null) {
                for (Xpp3Dom httpHeader : httpHeaders.getChildren("property")) {
                    Xpp3Dom name = httpHeader.getChild("name");
                    String headerName = name.getValue();
                    Xpp3Dom value = httpHeader.getChild("value");
                    String headerValue = value.getValue();
                    headers.put(headerName, headerValue);
                }
            }
            serverConfigurations.put("aether.connector.http.headers." + server.getId(), headers);
            Xpp3Dom connectTimeoutNode = serverConfig.getChild("connectTimeout");
            if (connectTimeoutNode != null) {
                try {
                    connectTimeout = Integer.parseInt(connectTimeoutNode.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((requestTimeoutNode = serverConfig.getChild("requestTimeout")) == null) continue;
            try {
                requestTimeout = Integer.parseInt(requestTimeoutNode.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : settings.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        LocalRepositoryManagerFactory lrmFactory = registry.lookupByClass(LocalRepositoryManagerFactory.class);
        try {
            session.setLocalRepositoryManager(lrmFactory.newInstance((RepositorySystemSession)session, new LocalRepository(localRepository)));
        }
        catch (NoLocalRepositoryManagerException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        session.setDependencyTraverser((DependencyTraverser)new FatArtifactTraverser());
        session.setDependencyManager((DependencyManager)new ClassicDependencyManager());
        AndDependencySelector depFilter = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test", "provided"}), new OptionalDependencySelector(), new ExclusionDependencySelector()});
        session.setDependencySelector((DependencySelector)depFilter);
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new NearestVersionSelector(), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        transformer = new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{transformer, new JavaDependencyContextRefiner()});
        session.setDependencyGraphTransformer((DependencyGraphTransformer)transformer);
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        stereotypes.add((ArtifactType)new DefaultArtifactType("pom"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("maven-plugin", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("jar", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ejb", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ejb-client", "jar", "client", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("test-jar", "jar", "tests", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("javadoc", "jar", "javadoc", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("java-source", "jar", "sources", "java", false, false));
        stereotypes.add((ArtifactType)new DefaultArtifactType("war", "war", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ear", "ear", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("rar", "rar", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("par", "par", "", "java", false, true));
        session.setArtifactTypeRegistry((ArtifactTypeRegistry)stereotypes);
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(true, true));
        session.setUserProperties(null);
        session.setSystemProperties((Map)systemProperties);
        session.setConfigProperties((Map)systemProperties);
        session.setConfigProperty("aether.connector.basic.threads", (Object)"4");
        session.setConfigProperty("aether.collector.impl", (Object)"df");
        session.setConfigProperty("aether.connector.connectTimeout", (Object)connectTimeout);
        session.setConfigProperty("aether.connector.requestTimeout", (Object)requestTimeout);
        serverConfigurations.forEach((arg_0, arg_1) -> ((DefaultRepositorySystemSession)session).setConfigProperty(arg_0, arg_1));
        session.setProxySelector((ProxySelector)proxySelector);
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        session.setChecksumPolicy(null);
        session.setUpdatePolicy(null);
        session.setAuthenticationSelector((AuthenticationSelector)authenticationSelector);
        session.setOffline(false);
        session.setIgnoreArtifactDescriptorRepositories(true);
        session.setWorkspaceReader(null);
        return session;
    }

    List<RemoteRepository> configureDefaultRepositories(Settings settings) {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        HashSet<String> repositoryURLs = new HashSet<String>();
        this.centralRepository = new RemoteRepository.Builder("central", "default", MAVEN_CENTRAL_REPO).setReleasePolicy(this.defaultPolicy).setSnapshotPolicy(POLICY_DISABLED).build();
        repositories.add(this.centralRepository);
        this.apacheSnapshotsRepository = new RemoteRepository.Builder("apache-snapshot", "default", APACHE_SNAPSHOT_REPO).setReleasePolicy(POLICY_DISABLED).setSnapshotPolicy(this.defaultPolicy).build();
        if (this.repos != null) {
            ArrayList<RemoteRepository> repositoriesFromConfiguration = new ArrayList<RemoteRepository>();
            Set<String> urls = Arrays.stream(this.repos.split("\\s*,\\s*")).collect(Collectors.toSet());
            this.configureRepositories(repositoriesFromConfiguration, urls);
            for (RemoteRepository repo : repositoriesFromConfiguration) {
                if (!repositoryURLs.add(repo.getUrl())) continue;
                if (repo == this.apacheSnapshotsRepository) {
                    this.apacheSnapshotsIncluded = true;
                }
                repositories.add(repo);
            }
        }
        for (String profile : settings.getActiveProfiles()) {
            for (Repository r : ((Profile)settings.getProfilesAsMap().get(profile)).getRepositories()) {
                try {
                    String checksumPolicy;
                    String updatePolicy;
                    URL url = new URL(r.getUrl());
                    if (!repositoryURLs.add(r.getUrl())) continue;
                    if (url.getHost().equals("repository.apache.org") && url.getPath().startsWith("/snapshots")) {
                        this.apacheSnapshotsIncluded = true;
                        repositories.add(this.apacheSnapshotsRepository);
                        continue;
                    }
                    RemoteRepository.Builder rb = new RemoteRepository.Builder(r.getId(), r.getLayout(), r.getUrl());
                    if (r.getReleases() == null) {
                        rb.setPolicy(this.defaultPolicy);
                    } else {
                        updatePolicy = r.getReleases().getUpdatePolicy() == null ? "daily" : r.getReleases().getUpdatePolicy();
                        checksumPolicy = r.getReleases().getChecksumPolicy() == null ? "warn" : r.getReleases().getChecksumPolicy();
                        rb.setPolicy(new RepositoryPolicy(r.getReleases().isEnabled(), updatePolicy, checksumPolicy));
                    }
                    if (r.getSnapshots() == null) {
                        rb.setSnapshotPolicy(POLICY_DISABLED);
                    } else {
                        updatePolicy = r.getSnapshots().getUpdatePolicy() == null ? "daily" : r.getSnapshots().getUpdatePolicy();
                        checksumPolicy = r.getSnapshots().getChecksumPolicy() == null ? "warn" : r.getSnapshots().getChecksumPolicy();
                        rb.setSnapshotPolicy(new RepositoryPolicy(r.getSnapshots().isEnabled(), updatePolicy, checksumPolicy));
                    }
                    repositories.add(rb.build());
                }
                catch (MalformedURLException e) {
                    LOG.warn("Can't use {} URL from Maven settings: {}. Skipping.", new Object[]{r.getUrl(), e.getMessage(), e});
                }
            }
        }
        return repositories;
    }

    private void configureRepositories(List<RemoteRepository> repositories, Set<String> urls) {
        urls.forEach(repo -> {
            try {
                repo = this.repositoryResolver.resolveRepository((String)repo);
                URL url = new URL((String)repo);
                if (url.getHost().equals("repo1.maven.org")) {
                    return;
                }
                if (url.getHost().equals("repository.apache.org") && url.getPath().contains("/snapshots")) {
                    repositories.add(this.apacheSnapshotsRepository);
                } else {
                    String id = "custom" + this.customRepositoryCounter.getAndIncrement();
                    repositories.add(new RemoteRepository.Builder(id, "default", repo).setReleasePolicy(this.defaultPolicy).setSnapshotPolicy(this.defaultPolicy).build());
                }
            }
            catch (MalformedURLException e) {
                LOG.warn("Can't use {} URL: {}. Skipping.", new Object[]{repo, e.getMessage(), e});
            }
        });
    }

    public void setMavenSettingsLocation(String mavenSettings) {
        this.mavenSettings = mavenSettings;
    }

    public void setMavenSettingsSecurityLocation(String mavenSettingsSecurity) {
        this.mavenSettingsSecurity = mavenSettingsSecurity;
    }

    public void setRepos(String repos) {
        this.repos = repos;
    }

    public void setFresh(boolean fresh) {
        this.fresh = fresh;
    }

    private static class AcceptAllDependencyFilter
    implements DependencyFilter {
        private AcceptAllDependencyFilter() {
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            return true;
        }
    }

    private static class AcceptDirectDependencyFilter
    implements DependencyFilter {
        private final List<ArtifactRequest> requests;

        public AcceptDirectDependencyFilter(List<ArtifactRequest> requests) {
            this.requests = requests;
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            Dependency dependency = node.getDependency();
            if (dependency == null) {
                return false;
            }
            Artifact current = dependency.getArtifact();
            for (ArtifactRequest ar : this.requests) {
                if (!current.getGroupId().equals(ar.getArtifact().getGroupId()) || !current.getArtifactId().equals(ar.getArtifact().getArtifactId()) || !current.getExtension().equals(ar.getArtifact().getExtension()) || !current.getClassifier().equals(ar.getArtifact().getClassifier())) continue;
                return true;
            }
            return false;
        }
    }
}

