/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util.srcgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.tooling.util.srcgen.Annotation;
import org.apache.camel.tooling.util.srcgen.Field;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.tooling.util.srcgen.Javadoc;
import org.apache.camel.tooling.util.srcgen.Method;
import org.apache.camel.tooling.util.srcgen.Param;
import org.apache.camel.tooling.util.srcgen.Property;

public class JavaClass {
    ClassLoader classLoader;
    JavaClass parent;
    String packageName;
    String name;
    String extendsName = "java.lang.Object";
    List<String> implementNames = new ArrayList<String>();
    List<String> imports = new ArrayList<String>();
    List<Annotation> annotations = new ArrayList<Annotation>();
    List<Property> properties = new ArrayList<Property>();
    List<Field> fields = new ArrayList<Field>();
    List<Method> methods = new ArrayList<Method>();
    List<JavaClass> nested = new ArrayList<JavaClass>();
    List<String> values = new ArrayList<String>();
    Javadoc javadoc = new Javadoc();
    boolean isStatic;
    boolean isPublic = true;
    boolean isPackagePrivate;
    boolean isAbstract;
    boolean isClass = true;
    boolean isEnum;
    int maxImportPerPackage = 10;

    public JavaClass() {
    }

    public JavaClass(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected JavaClass(JavaClass parent) {
        this.parent = parent;
    }

    protected ClassLoader getClassLoader() {
        if (this.classLoader == null && this.parent != null) {
            return this.parent.getClassLoader();
        }
        return this.classLoader;
    }

    public void setMaxImportPerPackage(int maxImportPerPackage) {
        this.maxImportPerPackage = maxImportPerPackage;
    }

    public JavaClass setStatic(boolean aStatic) {
        this.isStatic = aStatic;
        return this;
    }

    public JavaClass setPackagePrivate() {
        this.isPublic = false;
        this.isPackagePrivate = true;
        return this;
    }

    public JavaClass setPublic() {
        this.isPublic = true;
        this.isPackagePrivate = false;
        return this;
    }

    public String getPackage() {
        return this.packageName;
    }

    public JavaClass setPackage(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public JavaClass setName(String name) {
        this.name = name;
        return this;
    }

    public String getCanonicalName() {
        if (this.parent != null) {
            return this.parent.getCanonicalName() + "$" + this.name;
        }
        return this.packageName + "." + this.name;
    }

    public JavaClass extendSuperType(JavaClass extend) {
        return this.extendSuperType(extend.getName());
    }

    public JavaClass extendSuperType(String extendsName) {
        this.extendsName = extendsName;
        return this;
    }

    public String getSuperType() {
        return this.extendsName;
    }

    public JavaClass implementInterface(String implementName) {
        this.implementNames.add(implementName);
        return this;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void addImport(Class<?> clazz) {
        this.addImport(clazz.getName());
    }

    public void addImport(String importName) {
        this.imports.add(importName);
    }

    public void removeImport(String importName) {
        this.imports.remove(importName);
    }

    public void removeImport(JavaClass importName) {
        this.removeImport(importName.getCanonicalName());
    }

    public Annotation addAnnotation(String type) {
        try {
            Class<?> cl = this.getClassLoader().loadClass(type);
            return this.addAnnotation(cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to parse type", e);
        }
    }

    public <A extends java.lang.annotation.Annotation> Annotation addAnnotation(Class<A> type) {
        if (!java.lang.annotation.Annotation.class.isAssignableFrom(type)) {
            throw new IllegalStateException("Not an annotation: " + type.getName());
        }
        Annotation ann = new Annotation(type);
        this.annotations.add(ann);
        return ann;
    }

    public Property addProperty(String type, String name) {
        try {
            return this.addProperty(GenericType.parse(type, this.getClassLoader()), name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to parse type " + type + " for property " + name, e);
        }
    }

    public Property addProperty(GenericType type, String name) {
        Property prop = new Property(type, name);
        this.properties.add(prop);
        return prop;
    }

    public Javadoc getJavaDoc() {
        return this.javadoc;
    }

    public Field addField() {
        Field field = new Field();
        this.fields.add(field);
        return field;
    }

    public Method addMethod() {
        return this.addMethod(new Method());
    }

    public Method addMethod(Method method) {
        this.methods.add(method);
        return method;
    }

    public JavaClass addNestedType() {
        JavaClass clazz = new JavaClass(this);
        this.nested.add(clazz);
        return clazz;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public boolean isClass() {
        return this.isClass;
    }

    public JavaClass setClass(boolean isClass) {
        this.isClass = isClass;
        return this;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public JavaClass setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public JavaClass setEnum(boolean isEnum) {
        this.isEnum = isEnum;
        return this;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "JavaClass[" + this.getCanonicalName() + "]";
    }

    public String printClass() {
        return this.printClass(true);
    }

    public String printClass(boolean innerClassesLast) {
        StringBuilder sb = new StringBuilder();
        TreeSet<String> imports = new TreeSet<String>(Comparator.comparing(JavaClass::importOrder));
        imports.addAll(this.imports);
        this.addImports(imports);
        this.nested.forEach(jc -> jc.addImports(imports));
        imports.removeIf(f -> f.startsWith("java.lang.") || f.startsWith(this.packageName + "."));
        imports.removeIf(GenericType::isPrimitive);
        LinkedHashMap<String, List> importsByPackages = new LinkedHashMap<String, List>();
        for (String string : imports) {
            String key = string.substring(0, string.lastIndexOf(46));
            importsByPackages.computeIfAbsent(key, k -> new ArrayList()).add(string);
        }
        imports.clear();
        for (Map.Entry entry : importsByPackages.entrySet()) {
            if (((List)entry.getValue()).size() < this.maxImportPerPackage) {
                imports.addAll((Collection)entry.getValue());
                continue;
            }
            imports.add((String)entry.getKey() + ".*");
        }
        sb.append("package ").append(this.packageName).append(";\n");
        sb.append("\n");
        if (!imports.isEmpty()) {
            for (String string : imports) {
                sb.append("import ").append(string).append(";\n");
            }
            sb.append("\n");
        }
        this.printClass(innerClassesLast, sb, "");
        return sb.toString();
    }

    private void printClass(boolean innerClassesLast, StringBuilder sb, String indent) {
        this.printJavadoc(sb, indent, this.javadoc);
        this.printAnnotations(sb, indent, this.annotations);
        if (this.isEnum) {
            sb.append(indent).append(this.isPublic ? "public " : "").append(this.isStatic ? "static " : "").append("enum ").append(this.name).append(" {\n").append(indent).append("    ").append(String.join((CharSequence)(",\n" + indent + "    "), this.values)).append(";\n").append(indent).append("}");
            return;
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append(indent);
        if (this.isPublic) {
            sb2.append("public ");
        }
        if (this.isStatic) {
            sb2.append("static ");
        }
        sb2.append(this.isClass ? "class " : "interface ").append(this.name);
        if (this.extendsName != null && !"java.lang.Object".equals(this.extendsName)) {
            sb2.append(" extends ").append(this.extendsName);
        }
        if (!this.implementNames.isEmpty()) {
            sb2.append(this.isClass ? " implements " : " extends ").append(String.join((CharSequence)", ", this.implementNames));
        }
        sb2.append(" {");
        if (sb2.length() < 80) {
            sb.append((CharSequence)sb2).append("\n");
        } else {
            sb.append(indent);
            if (this.isPublic) {
                sb.append("public ");
            }
            if (this.isStatic) {
                sb.append("static ");
            }
            sb.append(this.isClass ? "class " : "interface ").append(this.name);
            if (this.extendsName != null && !"java.lang.Object".equals(this.extendsName)) {
                sb.append("\n");
                sb.append(indent).append("        extends\n");
                sb.append(indent).append("            ").append(this.extendsName);
            }
            if (!this.implementNames.isEmpty()) {
                sb.append("\n");
                sb.append(indent).append(this.isClass ? "        implements\n" : "        extends\n");
                sb.append(this.implementNames.stream().map(name -> indent + "            " + name).collect(Collectors.joining(",\n")));
            }
            sb.append(" {\n");
        }
        if (this.parent == null) {
            sb.append("\n");
        }
        for (Field field : this.fields) {
            this.printField(sb, indent + "    ", field);
        }
        for (Property property : this.properties) {
            if (property.field == null) continue;
            this.printField(sb, indent + "    ", property.field);
        }
        if (!innerClassesLast) {
            for (JavaClass nest : this.nested) {
                sb.append("\n");
                nest.printClass(innerClassesLast, sb, indent + "    ");
                sb.append("\n");
            }
        }
        for (Method method : this.methods) {
            this.printMethod(sb, indent + "    ", method);
        }
        for (Property property : this.properties) {
            if (property.accessor != null) {
                this.printMethod(sb, indent + "    ", property.accessor);
            }
            if (property.mutator == null) continue;
            this.printMethod(sb, indent + "    ", property.mutator);
        }
        if (innerClassesLast) {
            for (JavaClass nest : this.nested) {
                sb.append("\n");
                nest.printClass(innerClassesLast, sb, indent + "    ");
                sb.append("\n");
            }
        }
        sb.append(indent).append("}");
    }

    private void addImports(Set<String> imports) {
        this.annotations.forEach(ann -> this.addImports(imports, (Annotation)ann));
        this.fields.forEach(f -> this.addImports(imports, (Field)f));
        this.methods.forEach(m -> this.addImports(imports, (Method)m));
        this.properties.forEach(p -> this.addImports(imports, (Property)p));
    }

    private void addImports(Set<String> imports, Annotation annotation) {
        this.addImports(imports, annotation.type);
    }

    private void addImports(Set<String> imports, Property property) {
        this.addImports(imports, property.field);
        this.addImports(imports, property.accessor);
        this.addImports(imports, property.mutator);
    }

    private void addImports(Set<String> imports, Field field) {
        if (field != null) {
            field.annotations.forEach(a -> this.addImports(imports, (Annotation)a));
            this.addImports(imports, field.type);
        }
    }

    private void addImports(Set<String> imports, Method method) {
        if (method != null) {
            method.annotations.forEach(a -> this.addImports(imports, (Annotation)a));
            this.addImports(imports, method.returnType);
            method.parameters.forEach(p -> this.addImports(imports, p.type));
        }
    }

    private void addImports(Set<String> imports, GenericType type) {
        if (type != null) {
            this.addImports(imports, type.getRawClass());
            for (int i = 0; i < type.size(); ++i) {
                this.addImports(imports, type.getActualTypeArgument(i));
            }
        }
    }

    private void addImports(Set<String> imports, Class<?> clazz) {
        if (clazz != null) {
            if (clazz.isArray()) {
                this.addImports(imports, clazz.getComponentType());
            } else {
                imports.add(clazz.getName().replace('$', '.'));
            }
        }
    }

    private void printMethod(StringBuilder sb, String indent, Method method) {
        if (this.fields.size() + this.properties.size() > 0) {
            sb.append("\n");
        }
        if (method.javadoc.text != null) {
            this.printJavadoc(sb, indent, method.javadoc);
        }
        this.printAnnotations(sb, indent, method.annotations);
        if (method.signature != null) {
            sb.append(indent);
            sb.append(method.signature);
            if (!method.isAbstract) {
                sb.append(" {");
            }
        } else {
            StringBuilder sb2 = new StringBuilder();
            sb2.append(indent);
            if (method.isPublic) {
                sb2.append("public ");
            } else if (method.isProtected) {
                sb2.append("protected ");
            } else if (method.isPrivate) {
                sb2.append("private ");
            }
            if (method.isDefault) {
                sb2.append("default ");
            }
            if (method.isStatic) {
                sb2.append("static ");
            }
            if (!method.isConstructor) {
                if (method.returnTypeLiteral != null) {
                    sb2.append(method.returnTypeLiteral);
                } else if (method.returnType != null) {
                    sb2.append(this.shortName(method.returnType));
                } else {
                    sb2.append("void");
                }
                sb2.append(" ");
            }
            sb2.append(method.name);
            sb2.append("(");
            sb2.append(method.parameters.stream().map(p -> p.vararg ? this.typeOf((Param)p) + "... " + p.name : this.typeOf((Param)p) + " " + p.name).collect(Collectors.joining(", ")));
            sb2.append(") ");
            if (!method.exceptions.isEmpty()) {
                sb2.append("throws ");
                sb2.append(method.exceptions.stream().map(this::shortName).collect(Collectors.joining(", ", "", " ")));
            }
            if (!method.isAbstract) {
                sb2.append("{");
            }
            if (sb2.length() < 84) {
                sb.append((CharSequence)sb2);
            } else {
                sb.append(indent);
                if (method.isPublic) {
                    sb.append("public ");
                } else if (method.isProtected) {
                    sb.append("protected ");
                } else if (method.isPrivate) {
                    sb.append("private ");
                }
                if (method.isStatic) {
                    sb.append("static ");
                }
                if (method.isDefault) {
                    sb.append("default ");
                }
                if (!method.isConstructor) {
                    if (method.returnTypeLiteral != null) {
                        sb.append(method.returnTypeLiteral);
                    } else if (method.returnType != null) {
                        sb.append(this.shortName(method.returnType));
                    } else {
                        sb.append("void");
                    }
                    sb.append(" ");
                }
                sb.append(method.name);
                if (!method.parameters.isEmpty()) {
                    sb.append("(\n");
                    sb.append(method.parameters.stream().map(p -> p.vararg ? indent + "        " + this.typeOf((Param)p) + "... " + p.name : indent + "        " + this.typeOf((Param)p) + " " + p.name).collect(Collectors.joining(",\n")));
                    sb.append(")");
                } else {
                    sb.append("()");
                }
                if (!method.exceptions.isEmpty()) {
                    sb.append("\n            throws");
                    sb.append(method.exceptions.stream().map(this::shortName).collect(Collectors.joining(", ", " ", "")));
                }
                if (!method.isAbstract) {
                    sb.append(" {");
                }
            }
        }
        if (!method.isAbstract) {
            sb.append("\n");
            for (String l : method.body.split("\n")) {
                sb.append(indent);
                sb.append("    ");
                sb.append(l);
                sb.append("\n");
            }
            sb.append(indent).append("}\n");
        } else {
            sb.append(";\n");
        }
    }

    private void printField(StringBuilder sb, String indent, Field field) {
        if (field.javadoc.text != null) {
            this.printJavadoc(sb, indent, field.javadoc);
        }
        if (field.comment != null) {
            this.printComment(sb, indent, field.comment);
        }
        this.printAnnotations(sb, indent, field.annotations);
        sb.append(indent);
        if (field.isPublic) {
            sb.append("public ");
        } else if (field.isPrivate) {
            sb.append("private ");
        }
        if (field.isStatic) {
            sb.append("static ");
        }
        if (field.isFinal) {
            sb.append("final ");
        }
        sb.append(this.shortName(field.type));
        sb.append(" ");
        sb.append(field.name);
        if (field.literalInit != null) {
            sb.append(" = ");
            sb.append(field.literalInit);
        }
        sb.append(";\n");
    }

    private void printJavadoc(StringBuilder sb, String indent, Javadoc doc) {
        List<String> lines = this.formatJavadocOrCommentStringAsList(doc.text, indent);
        if (!lines.isEmpty()) {
            sb.append(indent).append("/**\n");
            for (String line : lines) {
                sb.append(indent).append(" * ").append(line).append("\n");
            }
            sb.append(indent).append(" */\n");
        }
    }

    private void printComment(StringBuilder stringBuilder, String indent, String comment) {
        List<String> lines = this.formatJavadocOrCommentStringAsList(comment, indent);
        if (!lines.isEmpty()) {
            for (String line : lines) {
                stringBuilder.append(indent).append("// ").append(line).append("\n");
            }
        }
    }

    private List<String> formatJavadocOrCommentStringAsList(String text, String indent) {
        ArrayList<String> lines = new ArrayList<String>();
        int len = 78 - indent.length();
        String rem = text;
        if (rem != null) {
            while (!rem.isEmpty()) {
                int idx = rem.length() >= len ? rem.substring(0, len).lastIndexOf(32) : -1;
                int idx2 = rem.indexOf(10);
                if (idx2 >= 0 && (idx < 0 || idx2 < idx || idx2 < len)) {
                    idx = idx2;
                }
                if (idx >= 0) {
                    String s = rem.substring(0, idx);
                    while (s.endsWith(" ")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    String l = rem.substring(idx + 1);
                    while (l.startsWith(" ")) {
                        l = l.substring(1);
                    }
                    lines.add(s);
                    rem = l;
                    continue;
                }
                lines.add(rem);
                rem = "";
            }
        }
        return lines;
    }

    private void printAnnotations(StringBuilder sb, String indent, List<Annotation> anns) {
        if (anns != null) {
            for (Annotation ann : anns) {
                sb.append(indent);
                sb.append("@");
                sb.append(this.shortName(ann.type.getName()));
                if (!ann.values.isEmpty()) {
                    sb.append("(");
                    int i = 0;
                    for (Map.Entry<String, String> e : ann.values.entrySet()) {
                        if (i++ > 0) {
                            sb.append(", ");
                        }
                        if (Objects.equals(e.getKey(), "value") && ann.values.size() == 1) {
                            sb.append(e.getValue());
                            continue;
                        }
                        sb.append(e.getKey()).append(" = ").append(e.getValue());
                    }
                    sb.append(")");
                }
                sb.append("\n");
            }
        }
    }

    private String typeOf(Param p) {
        return p.typeLiteral != null ? p.typeLiteral : this.shortName(p.type);
    }

    private String shortName(GenericType name) {
        return this.shortName(name.toString());
    }

    private String shortName(String name) {
        String s = name.replace('$', '.');
        if ((s = s.replaceAll("([a-z][a-z0-9]+\\.([a-z][a-z0-9_]+\\.)*([A-Z][a-zA-Z0-9_]+\\.)?)([A-za-z]+)", "$4")).startsWith(this.name + ".")) {
            s = s.substring(this.name.length() + 1);
        }
        return s;
    }

    private static String importOrder(String s1) {
        if (((String)s1).startsWith("java.")) {
            s1 = "___" + (String)s1;
        }
        if (((String)s1).startsWith("javax.")) {
            s1 = "__" + (String)s1;
        }
        if (((String)s1).startsWith("org.w3c.")) {
            s1 = "_" + (String)s1;
        }
        return s1;
    }
}

