/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.client.management.invoker;

import java.util.Map;
import org.apache.camel.component.torchserve.client.management.invoker.ServerVariable;

public class ServerConfiguration {
    public String URL;
    public String description;
    public Map<String, ServerVariable> variables;

    public ServerConfiguration(String URL2, String description, Map<String, ServerVariable> variables) {
        this.URL = URL2;
        this.description = description;
        this.variables = variables;
    }

    public String URL(Map<String, String> variables) {
        String url = this.URL;
        for (Map.Entry<String, ServerVariable> variable : this.variables.entrySet()) {
            String name = variable.getKey();
            ServerVariable serverVariable = variable.getValue();
            String value = serverVariable.defaultValue;
            if (variables != null && variables.containsKey(name)) {
                value = variables.get(name);
                if (serverVariable.enumValues.size() > 0 && !serverVariable.enumValues.contains(value)) {
                    throw new IllegalArgumentException("The variable " + name + " in the server URL has invalid value " + value + ".");
                }
            }
            url = url.replace("{" + name + "}", value);
        }
        return url;
    }

    public String URL() {
        return this.URL(null);
    }
}

