/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing;

import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.slf4j.MDC;

public final class ActiveSpanManager {
    public static final String MDC_TRACE_ID = "traceId";
    public static final String MDC_SPAN_ID = "spanId";
    private static final String ACTIVE_SPAN_PROPERTY = "OpenTracing.activeSpan";

    private ActiveSpanManager() {
    }

    public static SpanAdapter getSpan(Exchange exchange) {
        Holder holder = (Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY);
        if (holder != null) {
            return holder.getSpan();
        }
        return null;
    }

    public static void activate(Exchange exchange, SpanAdapter span) {
        exchange.setProperty(ACTIVE_SPAN_PROPERTY, (Object)new Holder((Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY), span));
        if (exchange.getContext().isUseMDCLogging().booleanValue()) {
            MDC.put((String)MDC_TRACE_ID, (String)("" + span.traceId()));
            MDC.put((String)MDC_SPAN_ID, (String)("" + span.spanId()));
        }
    }

    public static void deactivate(Exchange exchange) {
        Holder holder = (Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY);
        if (holder != null) {
            exchange.setProperty(ACTIVE_SPAN_PROPERTY, (Object)holder.getParent());
            if (exchange.getContext().isUseMDCLogging().booleanValue()) {
                Holder parent = holder.getParent();
                if (parent != null) {
                    SpanAdapter span = holder.getParent().getSpan();
                    MDC.put((String)MDC_TRACE_ID, (String)("" + span.traceId()));
                    MDC.put((String)MDC_SPAN_ID, (String)("" + span.spanId()));
                } else {
                    MDC.remove((String)MDC_TRACE_ID);
                    MDC.remove((String)MDC_SPAN_ID);
                }
            }
        }
    }

    public static class Holder {
        private Holder parent;
        private SpanAdapter span;

        public Holder(Holder parent, SpanAdapter span) {
            this.parent = parent;
            this.span = span;
        }

        public Holder getParent() {
            return this.parent;
        }

        public SpanAdapter getSpan() {
            return this.span;
        }
    }
}

