/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.decorators.AbstractMessagingSpanDecorator;

public class NsqSpanDecorator
extends AbstractMessagingSpanDecorator {
    public static final String NSQ_MESSAGE_ID = "CamelNsqMessageId";
    public static final String NSQ_TOPIC = "CamelNsqMessageTopic";

    @Override
    public String getComponent() {
        return "nsq";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.nsq.NsqComponent";
    }

    @Override
    public String getDestination(Exchange exchange, Endpoint endpoint) {
        String topic = (String)exchange.getIn().getHeader(NSQ_TOPIC, String.class);
        if (topic == null) {
            Map<String, String> queryParameters = NsqSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
            topic = queryParameters.get("topic");
        }
        return topic != null ? topic : super.getDestination(exchange, endpoint);
    }

    @Override
    protected String getMessageId(Exchange exchange) {
        return (String)exchange.getIn().getHeader(NSQ_MESSAGE_ID, String.class);
    }
}

