/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing;

import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class ActiveSpanManager {
    public static final String MDC_TRACE_ID = "trace_id";
    public static final String MDC_SPAN_ID = "span_id";
    private static final String ACTIVE_SPAN_PROPERTY = "OpenTracing.activeSpan";
    private static final Logger LOG = LoggerFactory.getLogger(ActiveSpanManager.class);

    private ActiveSpanManager() {
    }

    public static SpanAdapter getSpan(Exchange exchange) {
        Holder holder = (Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY);
        if (holder != null) {
            return holder.getSpan();
        }
        return null;
    }

    public static void activate(Exchange exchange, SpanAdapter span) {
        exchange.setProperty(ACTIVE_SPAN_PROPERTY, (Object)new Holder((Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY), span));
        if (exchange.getContext().isUseMDCLogging().booleanValue()) {
            MDC.put((String)MDC_TRACE_ID, (String)span.traceId());
            MDC.put((String)MDC_SPAN_ID, (String)span.spanId());
        }
    }

    public static void deactivate(Exchange exchange) {
        Holder holder = (Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY);
        if (holder != null) {
            exchange.setProperty(ACTIVE_SPAN_PROPERTY, (Object)holder.getParent());
            holder.closeScope();
            if (exchange.getContext().isUseMDCLogging().booleanValue()) {
                Holder parent = holder.getParent();
                if (parent != null) {
                    SpanAdapter span = holder.getParent().getSpan();
                    MDC.put((String)MDC_TRACE_ID, (String)span.traceId());
                    MDC.put((String)MDC_SPAN_ID, (String)span.spanId());
                } else {
                    MDC.remove((String)MDC_TRACE_ID);
                    MDC.remove((String)MDC_SPAN_ID);
                }
            }
        }
    }

    public static void endScope(Exchange exchange) {
        Holder holder = (Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY);
        if (holder != null) {
            holder.closeScope();
        }
    }

    public static class Holder {
        private Holder parent;
        private SpanAdapter span;
        private AutoCloseable scope;

        public Holder(Holder parent, SpanAdapter span) {
            this.parent = parent;
            this.span = span;
            this.scope = new ScopeWrapper(span.makeCurrent(), Thread.currentThread().getId());
        }

        public Holder getParent() {
            return this.parent;
        }

        public SpanAdapter getSpan() {
            return this.span;
        }

        private void closeScope() {
            if (this.scope != null) {
                try {
                    this.scope.close();
                }
                catch (Exception e) {
                    LOG.debug("Failed to close span scope", (Throwable)e);
                }
                this.scope = null;
            }
        }
    }

    private static class ScopeWrapper
    implements AutoCloseable {
        private final long startThreadId;
        private final AutoCloseable inner;
        private boolean closed;

        public ScopeWrapper(AutoCloseable inner, long startThreadId) {
            this.startThreadId = startThreadId;
            this.inner = inner;
        }

        @Override
        public void close() throws Exception {
            if (!this.closed && Thread.currentThread().getId() == this.startThreadId) {
                this.closed = true;
                this.inner.close();
            } else {
                LOG.debug("not closing scope, closed - {}, started on thread - '{}', current thread - '{}'", new Object[]{this.closed, this.startThreadId, Thread.currentThread().getId()});
            }
        }
    }
}

