/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.decorators.AbstractSpanDecorator;

public class AzureStorageDataLakeSpanDecorator
extends AbstractSpanDecorator {
    static final String STORAGE_DATALAKE_DIRECTORY_NAME = "directoryName";
    static final String STORAGE_DATALAKE_FILE_NAME = "fileName";
    static final String STORAGE_DATALAKE_PATH = "path";
    static final String STORAGE_DATALAKE_TIMEOUT = "timeout";
    static final String STORAGE_DATALAKE_CONTENT_TYPE = "contentType";
    static final String STORAGE_DATALAKE_METADATA = "metadata";
    static final String STORAGE_DATALAKE_LAST_MODIFIED = "lastModified";
    static final String STORAGE_DATALAKE_POSITION = "position";
    static final String STORAGE_DATALAKE_EXPRESSION = "expression";
    static final String OPERATION = "CamelAzureStorageDataLakeOperation";
    static final String FILESYSTEM_NAME = "CamelAzureStorageDataLakeFileSystemName";
    static final String DIRECTORY_NAME = "CamelAzureStorageDataLakeDirectoryName";
    static final String FILE_NAME = "CamelAzureStorageDataLakeFileName";
    static final String PATH = "CamelAzureStorageDataLakePath";
    static final String TIMEOUT = "CamelAzureStorageDataLakeTimeout";
    static final String CONTENT_TYPE = "CamelAzureStorageDataLakeContentType";
    static final String METADATA = "CamelAzureStorageDataLakeMetadata";
    static final String LAST_MODIFIED = "CamelAzureStorageDataLakeLastModified";
    static final String POSITION = "CamelAzureStorageDataLakePosition";
    static final String EXPRESSION = "CamelAzureStorageDataLakeExpression";

    @Override
    public String getComponent() {
        return "azure-storage-datalake";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.azure.storage.datalake.DataLakeComponent";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        String operation = (String)exchange.getIn().getHeader(OPERATION, String.class);
        if (operation == null) {
            Map<String, String> queryParameters = AzureStorageDataLakeSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
            return queryParameters.containsKey("operation") ? queryParameters.get("operation") : super.getOperationName(exchange, endpoint);
        }
        return operation;
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        String expression;
        Long position;
        OffsetDateTime lastModified;
        Map metadata;
        String contentType;
        Duration timeout;
        String path;
        String fileName;
        String directoryName;
        super.pre(span, exchange, endpoint);
        span.setTag("db.system", this.getComponent());
        String fileSystemName = (String)exchange.getIn().getHeader(FILESYSTEM_NAME, String.class);
        if (fileSystemName != null) {
            span.setTag("db.name", fileSystemName);
        }
        if ((directoryName = (String)exchange.getIn().getHeader(DIRECTORY_NAME, String.class)) != null) {
            span.setTag(STORAGE_DATALAKE_DIRECTORY_NAME, directoryName);
        }
        if ((fileName = (String)exchange.getIn().getHeader(FILE_NAME, String.class)) != null) {
            span.setTag(STORAGE_DATALAKE_FILE_NAME, fileName);
        }
        if ((path = (String)exchange.getIn().getHeader(PATH, String.class)) != null) {
            span.setTag(STORAGE_DATALAKE_PATH, path);
        }
        if ((timeout = (Duration)exchange.getIn().getHeader(TIMEOUT, Duration.class)) != null) {
            span.setTag(STORAGE_DATALAKE_TIMEOUT, timeout.toString());
        }
        if ((contentType = (String)exchange.getIn().getHeader(CONTENT_TYPE, String.class)) != null) {
            span.setTag(STORAGE_DATALAKE_CONTENT_TYPE, contentType);
        }
        if ((metadata = (Map)exchange.getIn().getHeader(METADATA, Map.class)) != null) {
            span.setTag(STORAGE_DATALAKE_METADATA, metadata.toString());
        }
        if ((lastModified = (OffsetDateTime)exchange.getIn().getHeader(LAST_MODIFIED, OffsetDateTime.class)) != null) {
            span.setTag(STORAGE_DATALAKE_LAST_MODIFIED, lastModified.toString());
        }
        if ((position = (Long)exchange.getIn().getHeader(POSITION, Long.class)) != null) {
            span.setTag(STORAGE_DATALAKE_POSITION, (Number)position);
        }
        if ((expression = (String)exchange.getIn().getHeader(EXPRESSION, String.class)) != null) {
            span.setTag(STORAGE_DATALAKE_EXPRESSION, expression);
        }
    }
}

