/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.decorators.AbstractMessagingSpanDecorator;

public class JmsSpanDecorator
extends AbstractMessagingSpanDecorator {
    public static final String JMS_MESSAGE_ID = "JMSMessageID";

    @Override
    public String getComponent() {
        return "jms";
    }

    @Override
    protected String getDestination(Exchange exchange, Endpoint endpoint) {
        String destination = (String)exchange.getMessage().getHeader("CamelJmsDestinationName", String.class);
        if (destination == null) {
            destination = super.getDestination(exchange, endpoint);
        }
        return destination;
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.jms.JmsComponent";
    }

    @Override
    protected String getMessageId(Exchange exchange) {
        return (String)exchange.getIn().getHeader(JMS_MESSAGE_ID, String.class);
    }
}

