/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.Tag;
import org.apache.camel.tracing.decorators.AbstractSpanDecorator;

public class JdbcSpanDecorator
extends AbstractSpanDecorator {
    @Override
    public String getComponent() {
        return "jdbc";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.jdbc.JdbcComponent";
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        span.setLowCardinalityTag(Tag.DB_TYPE, "sql");
        Object body = exchange.getIn().getBody();
        if (body instanceof String) {
            span.setTag(Tag.DB_STATEMENT, (String)body);
        }
    }
}

