/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import org.apache.camel.component.twilio.TwilioConfiguration;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="sip-domain-credential-list-mapping", description="", apiMethods={@ApiMethod(methodName="creator", description="Create a CredentialListMappingCreator to execute create", signatures={"com.twilio.rest.api.v2010.account.sip.domain.CredentialListMappingCreator creator(String pathDomainSid, String credentialListSid)", "com.twilio.rest.api.v2010.account.sip.domain.CredentialListMappingCreator creator(String pathAccountSid, String pathDomainSid, String credentialListSid)"}), @ApiMethod(methodName="deleter", description="Create a CredentialListMappingDeleter to execute delete", signatures={"com.twilio.rest.api.v2010.account.sip.domain.CredentialListMappingDeleter deleter(String pathDomainSid, String pathSid)", "com.twilio.rest.api.v2010.account.sip.domain.CredentialListMappingDeleter deleter(String pathAccountSid, String pathDomainSid, String pathSid)"}), @ApiMethod(methodName="fetcher", description="Create a CredentialListMappingFetcher to execute fetch", signatures={"com.twilio.rest.api.v2010.account.sip.domain.CredentialListMappingFetcher fetcher(String pathDomainSid, String pathSid)", "com.twilio.rest.api.v2010.account.sip.domain.CredentialListMappingFetcher fetcher(String pathAccountSid, String pathDomainSid, String pathSid)"}), @ApiMethod(methodName="reader", description="Create a CredentialListMappingReader to execute read", signatures={"com.twilio.rest.api.v2010.account.sip.domain.CredentialListMappingReader reader(String pathDomainSid)", "com.twilio.rest.api.v2010.account.sip.domain.CredentialListMappingReader reader(String pathAccountSid, String pathDomainSid)"})}, aliases={"^creator$=create", "^deleter$=delete", "^fetcher$=fetch", "^reader$=read", "^updater$=update"})
@UriParams
@Configurer(extended=true)
public final class SipDomainCredentialListMappingEndpointConfiguration
extends TwilioConfiguration {
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="A string that identifies the CredentialList resource to map to the SIP domain")})
    private String credentialListSid;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="The unique sid that identifies this account"), @ApiMethod(methodName="deleter", description="The unique sid that identifies this account"), @ApiMethod(methodName="fetcher", description="The unique sid that identifies this account"), @ApiMethod(methodName="reader", description="The unique sid that identifies this account")})
    private String pathAccountSid;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="A string that identifies the SIP Domain for which the CredentialList resource will be mapped"), @ApiMethod(methodName="creator", description="A string that identifies the SIP Domain for which the CredentialList resource will be mapped"), @ApiMethod(methodName="deleter", description="A string that identifies the SIP Domain that includes the resource to delete"), @ApiMethod(methodName="deleter", description="A string that identifies the SIP Domain for which the CredentialList resource will be mapped"), @ApiMethod(methodName="fetcher", description="A string that identifies the SIP Domain that includes the resource to fetch"), @ApiMethod(methodName="fetcher", description="A string that identifies the SIP Domain for which the CredentialList resource will be mapped"), @ApiMethod(methodName="reader", description="A string that identifies the SIP Domain that includes the resource to read"), @ApiMethod(methodName="reader", description="A string that identifies the SIP Domain for which the CredentialList resource will be mapped")})
    private String pathDomainSid;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="deleter", description="A string that identifies the resource to delete"), @ApiMethod(methodName="fetcher", description="A string that identifies the resource to fetch")})
    private String pathSid;

    public String getCredentialListSid() {
        return this.credentialListSid;
    }

    public void setCredentialListSid(String credentialListSid) {
        this.credentialListSid = credentialListSid;
    }

    public String getPathAccountSid() {
        return this.pathAccountSid;
    }

    public void setPathAccountSid(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public String getPathDomainSid() {
        return this.pathDomainSid;
    }

    public void setPathDomainSid(String pathDomainSid) {
        this.pathDomainSid = pathDomainSid;
    }

    public String getPathSid() {
        return this.pathSid;
    }

    public void setPathSid(String pathSid) {
        this.pathSid = pathSid;
    }
}

