/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.TweeterStatusListener;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import org.apache.camel.component.twitter.consumer.streaming.StreamingConsumer;
import org.apache.camel.impl.DefaultConsumer;
import twitter4j.Status;

public class TwitterConsumerEvent
extends DefaultConsumer
implements TweeterStatusListener {
    private Twitter4JConsumer twitter4jConsumer;

    public TwitterConsumerEvent(TwitterEndpoint endpoint, Processor processor, Twitter4JConsumer twitter4jConsumer) {
        super((Endpoint)endpoint, processor);
        this.twitter4jConsumer = twitter4jConsumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.twitter4jConsumer instanceof StreamingConsumer) {
            ((StreamingConsumer)this.twitter4jConsumer).registerTweetListener(this);
            ((StreamingConsumer)this.twitter4jConsumer).doStart();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.twitter4jConsumer instanceof StreamingConsumer) {
            ((StreamingConsumer)this.twitter4jConsumer).unregisterTweetListener(this);
            ((StreamingConsumer)this.twitter4jConsumer).doStop();
        }
    }

    @Override
    public void onStatus(Status status) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)status);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange on status update", exchange, (Throwable)exchange.getException());
        }
    }
}

