/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.util.TwitterSorter;

public enum TwitterEventType {
    STATUS,
    DIRECT_MESSAGE,
    FAVORITE,
    UNFAVORITE,
    FOLLOW,
    UNFOLLOW,
    USERLIST_MEMBER_ADDITION,
    USERLIST_MEMBER_DELETION,
    USERLIST_SUBSCRIPTION,
    USERLIST_UNSUBSCRIPTION,
    USERLIST_CREATION,
    USERLIST_UPDATE,
    USERLIST_DELETETION,
    USER_PROFILE_UPDATE,
    USER_SUSPENSION,
    USER_DELETION,
    BLOCK,
    UNBLOCK,
    RETWEETED_RETWEET,
    FAVORITED_RETWEET,
    QUOTED_TWEET;


    public Exchange createExchange(TwitterEndpoint endpoint) {
        return this.createExchange(endpoint, null);
    }

    public <T> Exchange createExchange(TwitterEndpoint endpoint, T body) {
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelTwitterEventType", (Object)this.name());
        if (body != null) {
            exchange.getIn().setBody(body);
        }
        return exchange;
    }

    public <T> List<Exchange> createExchangeList(TwitterEndpoint endpoint, List<T> bodyList) {
        List<Exchange> exchanges = Collections.emptyList();
        if (bodyList != null && !bodyList.isEmpty()) {
            exchanges = new ArrayList<Exchange>(bodyList.size());
            for (int i = 0; i < bodyList.size(); ++i) {
                exchanges.add(this.createExchange(endpoint, bodyList.get(i)));
            }
        }
        if (!exchanges.isEmpty() && endpoint.getProperties().isSortById()) {
            exchanges = TwitterSorter.sortByStatusId(exchanges);
        }
        return exchanges;
    }
}

