/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.security;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.camel.component.spring.security.SpringSecurityConfiguration;
import org.apache.camel.component.undertow.spi.UndertowSecurityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class SpringSecurityProvider
implements UndertowSecurityProvider {
    public static final String PRINCIPAL_NAME_HEADER = SpringSecurityProvider.class.getName() + "_principal";
    private static final Logger LOG = LoggerFactory.getLogger(SpringSecurityProvider.class);
    private static final AttachmentKey<String> PRINCIPAL_NAME_KEY = AttachmentKey.create(String.class);
    private Filter securityFilter;

    public void addHeader(BiConsumer<String, Object> consumer, HttpServerExchange httpExchange) throws Exception {
        String principalName = (String)httpExchange.getAttachment(PRINCIPAL_NAME_KEY);
        consumer.accept(PRINCIPAL_NAME_HEADER, principalName);
    }

    public int authenticate(HttpServerExchange httpExchange, List<String> allowedRoles) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)httpExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest request = servletRequestContext.getServletRequest();
        ServletResponse response = servletRequestContext.getServletResponse();
        FilterChain fc = (servletRequest, servletResponse) -> {
            Authentication a = SecurityContextHolder.getContext().getAuthentication();
            if (a instanceof JwtAuthenticationToken) {
                LOG.debug("Authentication token is present.");
                boolean allowed = false;
                Collection grantedAuthorities = ((JwtAuthenticationToken)a).getAuthorities();
                for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                    if (!allowedRoles.contains(grantedAuthority.getAuthority())) continue;
                    LOG.debug("Authenticated principal {} has authority to access resource.", (Object)((JwtAuthenticationToken)a).getName());
                    allowed = true;
                    break;
                }
                if (allowed) {
                    httpExchange.putAttachment(PRINCIPAL_NAME_KEY, (Object)((JwtAuthenticationToken)a).getName());
                    httpExchange.setStatusCode(200);
                    return;
                }
                LOG.debug("Authenticated principal {} doesn't have authority to access resource.", (Object)((JwtAuthenticationToken)a).getName());
            } else {
                LOG.warn("Authentication token is not present. Access is FORBIDDEN.");
            }
            httpExchange.setStatusCode(403);
        };
        this.securityFilter.doFilter(request, response, fc);
        return httpExchange.getStatusCode();
    }

    public boolean acceptConfiguration(Object configuration, String endpointUri) throws Exception {
        if (configuration instanceof SpringSecurityConfiguration) {
            SpringSecurityConfiguration conf = (SpringSecurityConfiguration)configuration;
            this.securityFilter = conf.getSecurityFilter();
            return true;
        }
        return false;
    }

    public boolean requireServletContext() {
        return true;
    }
}

