/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.camel.Attachment;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHeaderFilterStrategy;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.impl.DefaultAttachment;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.channels.BlockingReadableByteChannel;
import org.xnio.channels.StreamSourceChannel;

public class DefaultUndertowHttpBinding
implements UndertowHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUndertowHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;
    private Boolean transferException;

    public DefaultUndertowHttpBinding() {
        this.headerFilterStrategy = new UndertowHeaderFilterStrategy();
        this.transferException = Boolean.FALSE;
    }

    public DefaultUndertowHttpBinding(HeaderFilterStrategy headerFilterStrategy, Boolean transferException) {
        this.headerFilterStrategy = headerFilterStrategy;
        this.transferException = transferException;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public Boolean isTransferException() {
        return this.transferException;
    }

    @Override
    public void setTransferException(Boolean transferException) {
        this.transferException = transferException;
    }

    @Override
    public Message toCamelMessage(HttpServerExchange httpExchange, Exchange exchange) throws Exception {
        DefaultMessage result = new DefaultMessage(exchange.getContext());
        this.populateCamelHeaders(httpExchange, (Map<String, Object>)result.getHeaders(), exchange);
        FormData formData = (FormData)httpExchange.getAttachment(FormDataParser.FORM_DATA);
        if (formData != null) {
            HashMap body = new HashMap();
            formData.forEach(arg_0 -> this.lambda$toCamelMessage$1(formData, (Message)result, body, exchange, arg_0));
            result.setBody(body);
        } else if (Methods.POST.equals(httpExchange.getRequestMethod()) || Methods.PUT.equals(httpExchange.getRequestMethod())) {
            result.setBody((Object)this.readFromChannel(httpExchange.getRequestChannel()));
        } else {
            result.setBody(null);
        }
        return result;
    }

    @Override
    public Message toCamelMessage(ClientExchange clientExchange, Exchange exchange) throws Exception {
        DefaultMessage result = new DefaultMessage(exchange.getContext());
        this.populateCamelHeaders(clientExchange.getResponse(), (Map<String, Object>)result.getHeaders(), exchange);
        result.setBody((Object)this.readFromChannel(clientExchange.getResponseChannel()));
        return result;
    }

    @Override
    public void populateCamelHeaders(HttpServerExchange httpExchange, Map<String, Object> headersMap, Exchange exchange) throws Exception {
        Map predicateContextParams;
        LOG.trace("populateCamelHeaders: {}");
        String path = httpExchange.getRequestPath();
        UndertowEndpoint endpoint = (UndertowEndpoint)exchange.getFromEndpoint();
        if (endpoint.getHttpURI() != null) {
            String string;
            String endpointPath = endpoint.getHttpURI().getPath();
            String matchPath = path.toLowerCase(Locale.US);
            if (matchPath.startsWith(string = endpointPath.toLowerCase(Locale.US))) {
                path = path.substring(endpointPath.length());
            }
        }
        headersMap.put("CamelHttpPath", path);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP-Method {}", (Object)httpExchange.getRequestMethod());
            LOG.trace("HTTP-Uri {}", (Object)httpExchange.getRequestURI());
        }
        for (Object name : httpExchange.getRequestHeaders().getHeaderNames()) {
            String string;
            if (name.toString().toLowerCase(Locale.US).equals("content-type")) {
                name = ExchangeHeaders.CONTENT_TYPE;
            }
            if (name.toString().toLowerCase(Locale.US).equals("authorization") && (string = httpExchange.getRequestHeaders().get((HttpString)name).toString()) != null && string.trim().startsWith("Basic") && this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", (Object)"Basic", exchange)) {
                UndertowHelper.appendHeader(headersMap, "CamelAuthentication", "Basic");
            }
            for (Object value2 : httpExchange.getRequestHeaders().get((HttpString)name)) {
                LOG.trace("HTTP-header: {}", value2);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name.toString(), value2, exchange)) continue;
                UndertowHelper.appendHeader(headersMap, name.toString(), value2);
            }
        }
        Map pathParameters = httpExchange.getQueryParameters();
        if (!pathParameters.isEmpty()) {
            for (Map.Entry entry : pathParameters.entrySet()) {
                String name = (String)entry.getKey();
                Object values = entry.getValue();
                Iterator it = ObjectHelper.createIterator(values);
                while (it.hasNext()) {
                    Object value = it.next();
                    LOG.trace("URI-Parameter: {}", value);
                    if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, value, exchange)) continue;
                    UndertowHelper.appendHeader(headersMap, name, value);
                }
            }
        }
        if ((predicateContextParams = (Map)httpExchange.getAttachment(Predicate.PREDICATE_CONTEXT)) != null) {
            predicateContextParams.remove("remaining");
            for (String paramName : predicateContextParams.keySet()) {
                LOG.trace("REST Template Variable {}: {})", (Object)paramName, predicateContextParams.get(paramName));
                headersMap.put(paramName, predicateContextParams.get(paramName));
            }
        }
        headersMap.put("CamelHttpMethod", httpExchange.getRequestMethod().toString());
        headersMap.put("CamelHttpUrl", httpExchange.getRequestURL());
        headersMap.put("CamelHttpUri", httpExchange.getRequestURI());
        headersMap.put("CamelHttpQuery", httpExchange.getQueryString());
        headersMap.put("CamelHttpRawQuery", httpExchange.getQueryString());
    }

    @Override
    public void populateCamelHeaders(ClientResponse response, Map<String, Object> headersMap, Exchange exchange) throws Exception {
        LOG.trace("populateCamelHeaders: {}");
        headersMap.put("CamelHttpResponseCode", response.getResponseCode());
        for (HttpString name : response.getResponseHeaders().getHeaderNames()) {
            String value;
            if (name.toString().toLowerCase(Locale.US).equals("content-type")) {
                name = ExchangeHeaders.CONTENT_TYPE;
            }
            if (name.toString().toLowerCase(Locale.US).equals("authorization") && (value = response.getResponseHeaders().get(name).toString()) != null && value.trim().startsWith("Basic") && this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", (Object)"Basic", exchange)) {
                UndertowHelper.appendHeader(headersMap, "CamelAuthentication", "Basic");
            }
            for (Object value2 : response.getResponseHeaders().get(name)) {
                LOG.trace("HTTP-header: {}", value2);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name.toString(), value2, exchange)) continue;
                UndertowHelper.appendHeader(headersMap, name.toString(), value2);
            }
        }
    }

    @Override
    public Object toHttpResponse(HttpServerExchange httpExchange, Message message) throws IOException {
        String contentType;
        boolean failed = message.getExchange().isFailed();
        int defaultCode = failed ? 500 : 200;
        int code = (Integer)message.getHeader("CamelHttpResponseCode", (Object)defaultCode, Integer.TYPE);
        httpExchange.setStatusCode(code);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                httpExchange.getResponseHeaders().add(new HttpString(key), headerValue);
            }
        }
        Object body = message.getBody();
        Exception exception = message.getExchange().getException();
        if (exception != null) {
            if (this.isTransferException().booleanValue()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(exception);
                oos.flush();
                IOHelper.close((Closeable[])new Closeable[]{oos, bos});
                body = ByteBuffer.wrap(bos.toByteArray());
                message.setHeader("Content-Type", (Object)"application/x-java-serialized-object");
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                body = ByteBuffer.wrap(sw.toString().getBytes());
                message.setHeader("Content-Type", (Object)"text/plain");
            }
            ExchangeHelper.setFailureHandled((Exchange)message.getExchange());
        }
        if ((contentType = MessageHelper.getContentType((Message)message)) != null) {
            httpExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        return body;
    }

    @Override
    public Object toHttpRequest(ClientRequest clientRequest, Message message) {
        Object body = message.getBody();
        HeaderMap requestHeaders = clientRequest.getRequestHeaders();
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            requestHeaders.put(Headers.CONTENT_TYPE, contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                requestHeaders.add(new HttpString(key), headerValue);
            }
        }
        return body;
    }

    byte[] readFromChannel(StreamSourceChannel source) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[1024]);
        BlockingReadableByteChannel blockingSource = new BlockingReadableByteChannel(source);
        int res;
        while ((res = blockingSource.read(buffer)) != -1) {
            if (res == 0) {
                LOG.error("Channel did not block");
                continue;
            }
            buffer.flip();
            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit());
            buffer.clear();
        }
        return out.toByteArray();
    }

    private /* synthetic */ void lambda$toCamelMessage$1(FormData formData, Message result, Map body, Exchange exchange, String key) {
        formData.get(key).forEach(value -> {
            if (value.isFile()) {
                DefaultAttachment attachment = new DefaultAttachment((DataSource)new FilePartDataSource((FormData.FormValue)value));
                result.addAttachmentObject(key, (Attachment)attachment);
                body.put(key, attachment.getDataHandler());
            } else if (this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders(key, (Object)value.getValue(), exchange)) {
                UndertowHelper.appendHeader(result.getHeaders(), key, value.getValue());
                UndertowHelper.appendHeader(body, key, value.getValue());
            }
        });
    }

    class FilePartDataSource
    extends FileDataSource {
        private String name;
        private String contentType;

        FilePartDataSource(FormData.FormValue value) {
            super(value.getPath().toFile());
            this.name = value.getFileName();
            this.contentType = value.getHeaders().getFirst(Headers.CONTENT_TYPE);
        }

        public String getName() {
            return this.name;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

