/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class UndertowEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpURI";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "undertow".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "httpURI", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(30);
        props.add("accessLog");
        props.add("accessLogReceiver");
        props.add("allowedRoles");
        props.add("bridgeErrorHandler");
        props.add("cookieHandler");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("fireWebSocketChannelEvents");
        props.add("handlers");
        props.add("headerFilterStrategy");
        props.add("httpMethodRestrict");
        props.add("httpURI");
        props.add("keepAlive");
        props.add("lazyStartProducer");
        props.add("matchOnUriPrefix");
        props.add("muteException");
        props.add("options");
        props.add("optionsEnabled");
        props.add("preserveHostHeader");
        props.add("reuseAddresses");
        props.add("securityConfiguration");
        props.add("securityProvider");
        props.add("sendTimeout");
        props.add("sendToAll");
        props.add("sslContextParameters");
        props.add("tcpNoDelay");
        props.add("throwExceptionOnFailure");
        props.add("transferException");
        props.add("undertowHttpBinding");
        props.add("useStreaming");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("option.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

