/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringQuoteHelper;

public final class StringHelper {
    private StringHelper() {
    }

    public static String sanitize(String s) {
        return s.replace(':', '-').replace('_', '-').replace('.', '-').replace('/', '-').replace('\\', '-');
    }

    public static String removeCRLF(String s) {
        return s.replace("\r", "").replace("\n", "");
    }

    public static int countChar(String s, char ch) {
        return StringHelper.countChar(s, ch, -1);
    }

    public static int countChar(String s, char ch, int end) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int matches = 0;
        int len = end < 0 ? s.length() : end;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (ch != c) continue;
            ++matches;
        }
        return matches;
    }

    public static String limitLength(String s, int maxLength) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        return s.length() <= maxLength ? s : s.substring(0, maxLength);
    }

    public static String removeQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        s = StringHelper.replaceAll(s, "'", "");
        s = StringHelper.replaceAll(s, "\"", "");
        return s;
    }

    public static String removeLeadingAndEndingQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        String copy = s.trim();
        if (copy.length() < 2) {
            return s;
        }
        if (copy.startsWith("'") && copy.endsWith("'")) {
            return copy.substring(1, copy.length() - 1);
        }
        if (copy.startsWith("\"") && copy.endsWith("\"")) {
            return copy.substring(1, copy.length() - 1);
        }
        return s;
    }

    public static boolean isQuoted(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return false;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("\"") && s.endsWith("\"");
    }

    public static String xmlEncode(String text) {
        if (text == null) {
            return "";
        }
        text = StringHelper.replaceAll(text, "&", "&amp;");
        text = StringHelper.replaceAll(text, "\"", "&quot;");
        text = StringHelper.replaceAll(text, "<", "&lt;");
        text = StringHelper.replaceAll(text, ">", "&gt;");
        return text;
    }

    public static boolean hasUpperCase(String text) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassName(String text) {
        String lastToken;
        String[] split;
        boolean result = false;
        if (text != null && (split = text.split("\\.")).length > 0 && (lastToken = split[split.length - 1]).length() > 0) {
            result = Character.isUpperCase(lastToken.charAt(0));
        }
        return result;
    }

    public static boolean hasStartToken(String expression, String language) {
        if (expression == null) {
            return false;
        }
        if ("simple".equalsIgnoreCase(language) && expression.contains("${")) {
            return true;
        }
        return language != null && expression.contains("$" + language + "{");
    }

    public static String replaceAll(String input, String from, String to) {
        if (ObjectHelper.isEmpty(input)) {
            return input;
        }
        if (from == null) {
            throw new IllegalArgumentException("from cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to cannot be null");
        }
        if (!input.contains(from)) {
            return input;
        }
        int len = from.length();
        int max = input.length();
        StringBuilder sb = new StringBuilder(max);
        int i = 0;
        while (i < max) {
            String token;
            if (i + len <= max && from.equals(token = input.substring(i, i + len))) {
                sb.append(to);
                i += len;
                continue;
            }
            sb.append(input.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static String toJson(String name, String value, boolean isMap) {
        if (isMap) {
            return "{ " + StringQuoteHelper.doubleQuote(name) + ": " + StringQuoteHelper.doubleQuote(value) + " }";
        }
        return StringQuoteHelper.doubleQuote(name) + ": " + StringQuoteHelper.doubleQuote(value);
    }

    public static String notEmpty(String value, String name) {
        if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty");
        }
        return value;
    }

    public static String notEmpty(String value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty on: " + on);
        }
        return value;
    }

    public static String[] splitOnCharacter(String value, String needle, int count) {
        String[] rc = new String[count];
        rc[0] = value;
        for (int i = 1; i < count; ++i) {
            String v = rc[i - 1];
            int p = v.indexOf(needle);
            if (p < 0) {
                return rc;
            }
            rc[i - 1] = v.substring(0, p);
            rc[i] = v.substring(p + 1);
        }
        return rc;
    }

    public static String removeStartingCharacters(String text, char ch) {
        int idx = 0;
        while (text.charAt(idx) == ch) {
            ++idx;
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    public static String capitalize(String text) {
        return StringHelper.capitalize(text, false);
    }

    public static String capitalize(String text, boolean dashToCamelCase) {
        if (dashToCamelCase) {
            text = StringHelper.dashToCamelCase(text);
        }
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        String answer = text.substring(0, 1).toUpperCase(Locale.ENGLISH);
        if (length > 1) {
            answer = answer + text.substring(1, length);
        }
        return answer;
    }

    public static String dashToCamelCase(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        if (text.indexOf(45) == -1) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '-') {
                sb.append(Character.toUpperCase(text.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String after(String text, String after) {
        int pos = text.indexOf(after);
        if (pos == -1) {
            return null;
        }
        return text.substring(pos + after.length());
    }

    public static String after(String text, String after, String defaultValue) {
        String answer = StringHelper.after(text, after);
        return answer != null ? answer : defaultValue;
    }

    public static <T> Optional<T> after(String text, String after, Function<String, T> mapper) {
        String result = StringHelper.after(text, after);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String afterLast(String text, String after) {
        int pos = text.lastIndexOf(after);
        if (pos == -1) {
            return null;
        }
        return text.substring(pos + after.length());
    }

    public static String afterLast(String text, String after, String defaultValue) {
        String answer = StringHelper.afterLast(text, after);
        return answer != null ? answer : defaultValue;
    }

    public static String before(String text, String before) {
        int pos = text.indexOf(before);
        return pos == -1 ? null : text.substring(0, pos);
    }

    public static String before(String text, String before, String defaultValue) {
        String answer = StringHelper.before(text, before);
        return answer != null ? answer : defaultValue;
    }

    public static <T> Optional<T> before(String text, String before, Function<String, T> mapper) {
        String result = StringHelper.before(text, before);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String beforeLast(String text, String before) {
        int pos = text.lastIndexOf(before);
        return pos == -1 ? null : text.substring(0, pos);
    }

    public static String beforeLast(String text, String before, String defaultValue) {
        String answer = StringHelper.beforeLast(text, before);
        return answer != null ? answer : defaultValue;
    }

    public static String between(String text, String after, String before) {
        if ((text = StringHelper.after(text, after)) == null) {
            return null;
        }
        return StringHelper.before(text, before);
    }

    public static <T> Optional<T> between(String text, String after, String before, Function<String, T> mapper) {
        String result = StringHelper.between(text, after, before);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String betweenOuterPair(String text, char before, char after) {
        if (text == null) {
            return null;
        }
        int pos = -1;
        int pos2 = -1;
        int count = 0;
        int count2 = 0;
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!doubleQuoted && ch == '\'') {
                singleQuoted = !singleQuoted;
            } else if (!singleQuoted && ch == '\"') {
                boolean bl = doubleQuoted = !doubleQuoted;
            }
            if (singleQuoted || doubleQuoted) continue;
            if (ch == before) {
                ++count;
            } else if (ch == after) {
                ++count2;
            }
            if (ch == before && pos == -1) {
                pos = i;
                continue;
            }
            if (ch != after) continue;
            pos2 = i;
        }
        if (pos == -1 || pos2 == -1) {
            return null;
        }
        if (count != count2) {
            return null;
        }
        return text.substring(pos + 1, pos2);
    }

    public static <T> Optional<T> betweenOuterPair(String text, char before, char after, Function<String, T> mapper) {
        String result = StringHelper.betweenOuterPair(text, before, after);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int size = name.length();
        if (size < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            for (int i = 1; i < size; ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String normalizeClassName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (char ch : name.toCharArray()) {
            if (ch != '.' && ch != '[' && ch != ']' && ch != '-' && !Character.isJavaIdentifierPart(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static List<Integer> changedLines(String oldText, String newText) {
        if (oldText == null || oldText.equals(newText)) {
            return Collections.emptyList();
        }
        ArrayList<Integer> changed = new ArrayList<Integer>();
        String[] oldLines = oldText.split("\n");
        String[] newLines = newText.split("\n");
        for (int i = 0; i < newLines.length; ++i) {
            String oldLine;
            String newLine = newLines[i];
            String string = oldLine = i < oldLines.length ? oldLines[i] : null;
            if (oldLine == null) {
                changed.add(i);
                continue;
            }
            if (newLine.equals(oldLine)) continue;
            changed.add(i);
        }
        return changed;
    }

    public static String trimToNull(String given) {
        if (given == null) {
            return null;
        }
        String trimmed = given.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return trimmed;
    }

    public static boolean containsIgnoreCase(String src, String what) {
        if (src == null || what == null) {
            return false;
        }
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String humanReadableBytes(Locale locale, long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return String.format(locale, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableBytes(long bytes) {
        return StringHelper.humanReadableBytes(Locale.getDefault(), bytes);
    }

    public static boolean matches(String pattern, String target) {
        if (Objects.equals(pattern, target)) {
            return true;
        }
        if (Objects.isNull(pattern)) {
            return true;
        }
        if (Objects.equals("*", pattern)) {
            return true;
        }
        if (AntPathMatcher.INSTANCE.match(pattern, target)) {
            return true;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(target);
        return m.matches();
    }

    public static String camelCaseToDash(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder answer = new StringBuilder();
        Character prev = null;
        Character next = null;
        char[] arr = text.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            next = i < arr.length - 1 ? Character.valueOf(arr[i + 1]) : null;
            if (ch == '-' || ch == '_') {
                answer.append("-");
            } else if (Character.isUpperCase(ch) && prev != null && !Character.isUpperCase(prev.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else if (Character.isUpperCase(ch) && prev != null && next != null && Character.isLowerCase(next.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else {
                answer.append(ch);
            }
            prev = Character.valueOf(ch);
        }
        return answer.toString().toLowerCase(Locale.ENGLISH);
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        if (text != null && prefix != null) {
            return prefix.length() > text.length() ? false : text.regionMatches(true, 0, prefix, 0, prefix.length());
        }
        return text == null && prefix == null;
    }

    public static String asEnumConstantValue(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        value = StringHelper.camelCaseToDash(value);
        value = value.replaceAll("-+", "-");
        value = value.replace('-', '_').toUpperCase(Locale.ENGLISH);
        return value;
    }

    public static String[] splitWords(String text) {
        return text.split("[\\W]+");
    }

    public static Stream<String> splitAsStream(CharSequence text, String regex) {
        if (text == null || regex == null) {
            return Stream.empty();
        }
        return Pattern.compile(regex).splitAsStream(text);
    }

    public static int countOccurence(String text, String search) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = text.indexOf(search, lastIndex)) == -1) continue;
            ++count;
            lastIndex += search.length();
        }
        return count;
    }

    public static String replaceFromSecondOccurence(String text, String search, String repl) {
        int index = text.indexOf(search);
        boolean replace = false;
        while (index != -1) {
            String tempString = text.substring(index);
            if (replace) {
                tempString = tempString.replaceFirst(search, repl);
                text = text.substring(0, index) + tempString;
                replace = false;
            } else {
                replace = true;
            }
            index = text.indexOf(search, index + 1);
        }
        return text;
    }
}

