/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.common;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.vertx.common.VertxJsonArrayConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class VertxJsonArrayConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        VertxJsonArrayConverterLoader.addTypeConverter(registry, byte[].class, JsonArray.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toBytes((JsonArray)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, Buffer.class, JsonArray.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toBuffer((JsonArray)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, JsonArray.class, byte[].class, false, (type, exchange, value) -> VertxJsonArrayConverter.toJsonArray((byte[])value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, JsonArray.class, ByteBuf.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toJsonArray((ByteBuf)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, JsonArray.class, Buffer.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toJsonArray((Buffer)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, JsonArray.class, InputStream.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toJsonArray((InputStream)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, JsonArray.class, String.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toJsonArray((String)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, JsonArray.class, List.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toJsonArray((List)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, InputStream.class, JsonArray.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toInputStream((JsonArray)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, String.class, JsonArray.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toString((JsonArray)value));
        VertxJsonArrayConverterLoader.addTypeConverter(registry, List.class, JsonArray.class, false, (type, exchange, value) -> VertxJsonArrayConverter.toList((JsonArray)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

