/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.common;

import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.vertx.common.KeyManagerFactoryOptions;
import org.apache.camel.component.vertx.common.TrustManagerFactoryOptions;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;

public final class VertxHelper {
    private VertxHelper() {
    }

    public static void setupSSLOptions(CamelContext camelContext, SSLContextParameters sslContextParameters, TCPSSLOptions tcpsslOptions) throws Exception {
        if (camelContext == null) {
            throw new IllegalArgumentException("camelContext cannot be null");
        }
        if (sslContextParameters == null) {
            throw new IllegalArgumentException("sslContextParameters cannot be null");
        }
        if (tcpsslOptions == null) {
            throw new IllegalArgumentException("tcpsslOptions cannot be null");
        }
        tcpsslOptions.setSsl(true);
        KeyManagerFactory keyManagerFactory = VertxHelper.createKeyManagerFactory(camelContext, sslContextParameters);
        tcpsslOptions.setKeyCertOptions((KeyCertOptions)new KeyManagerFactoryOptions(keyManagerFactory));
        TrustManagerFactory trustManagerFactory = VertxHelper.createTrustManagerFactory(camelContext, sslContextParameters);
        tcpsslOptions.setTrustOptions((TrustOptions)new TrustManagerFactoryOptions(trustManagerFactory));
    }

    private static KeyManagerFactory createKeyManagerFactory(CamelContext camelContext, SSLContextParameters sslContextParameters) throws Exception {
        KeyManagersParameters keyManagers = sslContextParameters.getKeyManagers();
        if (keyManagers == null) {
            return null;
        }
        String kmfAlgorithm = camelContext.resolvePropertyPlaceholders(keyManagers.getAlgorithm());
        if (kmfAlgorithm == null) {
            kmfAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        KeyManagerFactory kmf = keyManagers.getProvider() == null ? KeyManagerFactory.getInstance(kmfAlgorithm) : KeyManagerFactory.getInstance(kmfAlgorithm, camelContext.resolvePropertyPlaceholders(keyManagers.getProvider()));
        char[] kmfPassword = null;
        if (keyManagers.getKeyPassword() != null) {
            kmfPassword = camelContext.resolvePropertyPlaceholders(keyManagers.getKeyPassword()).toCharArray();
        }
        KeyStore ks = keyManagers.getKeyStore() == null ? null : keyManagers.getKeyStore().createKeyStore();
        kmf.init(ks, kmfPassword);
        return kmf;
    }

    private static TrustManagerFactory createTrustManagerFactory(CamelContext camelContext, SSLContextParameters sslContextParameters) throws Exception {
        TrustManagersParameters trustManagers = sslContextParameters.getTrustManagers();
        if (trustManagers == null) {
            return null;
        }
        TrustManagerFactory tmf = null;
        if (trustManagers.getKeyStore() != null) {
            String tmfAlgorithm = camelContext.resolvePropertyPlaceholders(trustManagers.getAlgorithm());
            if (tmfAlgorithm == null) {
                tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            tmf = trustManagers.getProvider() == null ? TrustManagerFactory.getInstance(tmfAlgorithm) : TrustManagerFactory.getInstance(tmfAlgorithm, camelContext.resolvePropertyPlaceholders(trustManagers.getProvider()));
            KeyStore ks = trustManagers.getKeyStore() == null ? null : trustManagers.getKeyStore().createKeyStore();
            tmf.init(ks);
        }
        return tmf;
    }
}

