/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class VertxHttpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "vertx-http".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "httpUri", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(24);
        props.add("throwExceptionOnFailure");
        props.add("proxyUsername");
        props.add("sessionManagement");
        props.add("webClientOptions");
        props.add("proxyPassword");
        props.add("proxyType");
        props.add("basicAuthPassword");
        props.add("sslContextParameters");
        props.add("httpMethod");
        props.add("useCompression");
        props.add("vertxHttpBinding");
        props.add("okStatusCodeRange");
        props.add("responsePayloadAsByteArray");
        props.add("proxyHost");
        props.add("timeout");
        props.add("proxyPort");
        props.add("lazyStartProducer");
        props.add("bearerToken");
        props.add("basicAuthUsername");
        props.add("httpUri");
        props.add("headerFilterStrategy");
        props.add("transferException");
        props.add("connectTimeout");
        props.add("cookieStore");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

