/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.multipart.MultipartForm;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.vertx.http.VertxHttpBinding;
import org.apache.camel.component.vertx.http.VertxHttpComponent;
import org.apache.camel.component.vertx.http.VertxHttpConfiguration;
import org.apache.camel.component.vertx.http.VertxHttpEndpoint;
import org.apache.camel.component.vertx.http.VertxHttpHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class VertxHttpProducer
extends DefaultAsyncProducer {
    public VertxHttpProducer(VertxHttpEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public VertxHttpEndpoint getEndpoint() {
        return (VertxHttpEndpoint)super.getEndpoint();
    }

    public VertxHttpComponent getComponent() {
        return this.getEndpoint().getComponent();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        block24: {
            VertxHttpConfiguration configuration = this.getEndpoint().getConfiguration();
            Message message = exchange.getMessage();
            try {
                VertxHttpBinding vertxHttpBinding = configuration.getVertxHttpBinding();
                HttpRequest<Buffer> request = vertxHttpBinding.prepareHttpRequest(this.getEndpoint(), exchange);
                Handler<AsyncResult<HttpResponse<Buffer>>> resultHandler = this.createResultHandler(exchange, callback);
                Object body = message.getBody();
                if (body == null) {
                    request.send(resultHandler);
                    break block24;
                }
                if (body instanceof MultiMap) {
                    request.sendForm((MultiMap)body, resultHandler);
                    break block24;
                }
                if (body instanceof MultipartForm) {
                    request.sendMultipartForm((MultipartForm)body, resultHandler);
                    break block24;
                }
                if (body instanceof ReadStream) {
                    request.sendStream((ReadStream)body, resultHandler);
                    break block24;
                }
                if (body instanceof String) {
                    if (VertxHttpHelper.isContentTypeMatching(exchange, "application/x-www-form-urlencoded")) {
                        MultiMap map = MultiMap.caseInsensitiveMultiMap();
                        Map formParams = URISupport.parseQuery((String)((String)body));
                        formParams.keySet().forEach(key -> map.add(key, String.valueOf(formParams.get(key))));
                        request.sendForm(map, resultHandler);
                    } else {
                        String charset = VertxHttpHelper.getCharsetFromExchange(exchange);
                        Buffer buffer = ObjectHelper.isNotEmpty((Object)charset) ? Buffer.buffer((String)((String)body), (String)charset) : Buffer.buffer((String)((String)body));
                        request.sendBuffer(buffer, resultHandler);
                    }
                    break block24;
                }
                if (body instanceof Buffer) {
                    request.sendBuffer((Buffer)body, resultHandler);
                    break block24;
                }
                if (VertxHttpHelper.isContentTypeMatching(exchange, "application/x-java-serialized-object")) {
                    if (!this.getComponent().isAllowJavaSerializedObject()) {
                        throw new CamelExchangeException("Content-type application/x-java-serialized-object is not allowed", exchange);
                    }
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        Serializable serializable = (Serializable)message.getMandatoryBody(Serializable.class);
                        VertxHttpHelper.writeObjectToStream(baos, serializable);
                        request.sendBuffer(Buffer.buffer((byte[])baos.toByteArray()), resultHandler);
                        break block24;
                    }
                }
                Buffer buffer = (Buffer)message.getMandatoryBody(Buffer.class);
                request.sendBuffer(buffer, resultHandler);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        return false;
    }

    private Handler<AsyncResult<HttpResponse<Buffer>>> createResultHandler(Exchange exchange, AsyncCallback callback) {
        return response -> {
            try {
                VertxHttpEndpoint endpoint = this.getEndpoint();
                VertxHttpBinding vertxHttpBinding = endpoint.getConfiguration().getVertxHttpBinding();
                vertxHttpBinding.handleResponse(endpoint, exchange, (AsyncResult<HttpResponse<Buffer>>)response);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            finally {
                callback.done(false);
            }
        };
    }
}

