/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.vertx.http.VertxHttpBinding;
import org.apache.camel.component.vertx.http.VertxHttpConfiguration;
import org.apache.camel.component.vertx.http.VertxHttpEndpoint;
import org.apache.camel.component.vertx.http.VertxHttpHelper;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class DefaultVertxHttpBinding
implements VertxHttpBinding {
    @Override
    public HttpRequest<Buffer> prepareHttpRequest(VertxHttpEndpoint endpoint, Exchange exchange) throws Exception {
        URI uri;
        HttpMethod method;
        VertxHttpConfiguration configuration = endpoint.getConfiguration();
        Message message = exchange.getMessage();
        String queryString = VertxHttpHelper.resolveQueryString(exchange);
        if (ObjectHelper.isEmpty((Object)queryString)) {
            queryString = configuration.getHttpUri().getQuery();
        }
        if ((method = (HttpMethod)message.getHeader("CamelHttpMethod", (Object)configuration.getHttpMethod(), HttpMethod.class)) == null) {
            method = ObjectHelper.isNotEmpty((Object)queryString) ? HttpMethod.GET : (message.getBody() != null ? HttpMethod.POST : HttpMethod.GET);
        }
        if ((uri = VertxHttpHelper.resolveHttpURI(exchange)) == null) {
            uri = configuration.getHttpUri();
        }
        WebClient webClient = endpoint.getWebClient();
        HttpRequest request = uri.getPort() != -1 ? webClient.request(method, uri.getPort(), uri.getHost(), uri.getPath()) : webClient.requestAbs(method, uri.toString());
        if (ObjectHelper.isNotEmpty((Object)queryString)) {
            Map queryParams = URISupport.parseQuery((String)queryString);
            for (Map.Entry entry : queryParams.entrySet()) {
                request.addQueryParam((String)entry.getKey(), entry.getValue().toString());
            }
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getBasicAuthUsername()) && ObjectHelper.isNotEmpty((Object)configuration.getBasicAuthPassword())) {
            request.basicAuthentication(configuration.getBasicAuthUsername(), configuration.getBasicAuthPassword());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getBearerToken())) {
            request.bearerTokenAuthentication(configuration.getBearerToken());
        }
        this.populateRequestHeaders(exchange, (HttpRequest<Buffer>)request, configuration.getHeaderFilterStrategy());
        if (configuration.getTimeout() > -1L) {
            request.timeout(configuration.getTimeout());
        }
        return request;
    }

    @Override
    public void populateRequestHeaders(Exchange exchange, HttpRequest<Buffer> request, HeaderFilterStrategy strategy) {
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        if (ObjectHelper.isNotEmpty((Object)contentType)) {
            request.putHeader("Content-Type", contentType);
        }
        if (strategy != null) {
            TypeConverter tc = exchange.getContext().getTypeConverter();
            for (Map.Entry entry : exchange.getMessage().getHeaders().entrySet()) {
                Object headerValue;
                String key = (String)entry.getKey();
                if (strategy.applyFilterToCamelHeaders(key, headerValue = entry.getValue(), exchange)) continue;
                String str = (String)tc.convertTo(String.class, headerValue);
                request.putHeader(key, str);
            }
        }
    }

    @Override
    public void handleResponse(VertxHttpEndpoint endpoint, Exchange exchange, AsyncResult<HttpResponse<Buffer>> response) throws Exception {
        HttpResponse result = (HttpResponse)response.result();
        if (response.succeeded()) {
            Message message = exchange.getMessage();
            VertxHttpConfiguration configuration = endpoint.getConfiguration();
            boolean statusCodeOk = HttpHelper.isStatusCodeOk((int)result.statusCode(), (String)configuration.getOkStatusCodeRange());
            if (!configuration.isThrowExceptionOnFailure() || configuration.isThrowExceptionOnFailure() && statusCodeOk) {
                this.populateResponseHeaders(exchange, (HttpResponse<Buffer>)result, configuration.getHeaderFilterStrategy());
                message.setBody(this.processResponseBody(endpoint, exchange, (HttpResponse<Buffer>)result));
            } else {
                exchange.setException(this.handleResponseFailure(endpoint, exchange, (HttpResponse<Buffer>)result));
            }
        } else {
            exchange.setException(response.cause());
        }
    }

    @Override
    public void populateResponseHeaders(Exchange exchange, HttpResponse<Buffer> response, HeaderFilterStrategy strategy) {
        Message message = exchange.getMessage();
        message.setHeader("CamelHttpResponseCode", (Object)response.statusCode());
        message.setHeader("CamelHttpResponseText", (Object)response.statusMessage());
        MultiMap headers = response.headers();
        boolean found = false;
        Iterator iterator = headers.names().iterator();
        while (iterator.hasNext()) {
            String headerName;
            String name = headerName = (String)iterator.next();
            String value = headers.get(headerName);
            if (!found && name.equalsIgnoreCase("content-type")) {
                found = true;
                name = "Content-Type";
                exchange.setProperty("CamelCharsetName", (Object)IOHelper.getCharsetNameFromContentType((String)value));
            }
            Object extracted = HttpHelper.extractHttpParameterValue((String)value);
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
            HttpHelper.appendHeader((Map)message.getHeaders(), (String)name, (Object)extracted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processResponseBody(VertxHttpEndpoint endpoint, Exchange exchange, HttpResponse<Buffer> result, boolean exceptionOnly) throws Exception {
        Buffer responseBody = (Buffer)result.body();
        if (responseBody != null) {
            String contentType = result.getHeader("Content-Type");
            if (VertxHttpHelper.isContentTypeMatching("application/x-java-serialized-object", contentType)) {
                InputStream inputStream;
                boolean transferException = endpoint.getConfiguration().isTransferException();
                boolean allowJavaSerializedObject = endpoint.getComponent().isAllowJavaSerializedObject();
                if ((allowJavaSerializedObject || exceptionOnly && transferException) && (inputStream = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, (Object)responseBody.getBytes())) != null) {
                    try {
                        Object object = VertxHttpHelper.deserializeJavaObjectFromStream(inputStream);
                        return object;
                    }
                    finally {
                        IOHelper.close((Closeable)inputStream);
                    }
                }
            } else {
                return responseBody.getBytes();
            }
        }
        return null;
    }

    public Object processResponseBody(VertxHttpEndpoint endpoint, Exchange exchange, HttpResponse<Buffer> result) throws Exception {
        return this.processResponseBody(endpoint, exchange, result, false);
    }

    @Override
    public Throwable handleResponseFailure(VertxHttpEndpoint endpoint, Exchange exchange, HttpResponse<Buffer> result) throws Exception {
        Throwable exception;
        VertxHttpConfiguration configuration = endpoint.getConfiguration();
        Object responseBody = this.processResponseBody(endpoint, exchange, result, true);
        if (responseBody instanceof Throwable) {
            exception = (Throwable)responseBody;
        } else {
            String location = null;
            List redirects = result.followedRedirects();
            if (!redirects.isEmpty()) {
                location = (String)redirects.get(redirects.size() - 1);
            }
            HashMap headers = new HashMap();
            result.headers().names().forEach(header -> headers.put(header, result.getHeader(header)));
            URI httpURI = VertxHttpHelper.resolveHttpURI(exchange);
            if (httpURI == null) {
                httpURI = configuration.getHttpUri();
            }
            exception = new HttpOperationFailedException(httpURI.toString(), result.statusCode(), result.statusMessage(), location, headers, result.bodyAsString());
        }
        return exception;
    }
}

