/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.vertx.core.Vertx;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class VertxHttpHelper {
    private VertxHttpHelper() {
    }

    public static void setupSSLOptions(final SSLContextParameters sslContextParameters, TCPSSLOptions options) {
        options.setSsl(true);
        options.setKeyCertOptions(new KeyCertOptions(){

            public KeyManagerFactory getKeyManagerFactory(Vertx vertx) throws Exception {
                return VertxHttpHelper.createKeyManagerFactory(sslContextParameters);
            }

            public KeyCertOptions clone() {
                return this;
            }
        });
        options.setTrustOptions(new TrustOptions(){

            public TrustManagerFactory getTrustManagerFactory(Vertx vertx) throws Exception {
                return VertxHttpHelper.createTrustManagerFactory(sslContextParameters);
            }

            public TrustOptions clone() {
                return this;
            }
        });
    }

    public static String resolveQueryString(Exchange exchange) throws URISyntaxException {
        Message message = exchange.getMessage();
        String queryString = (String)message.removeHeader("CamelRestHttpQuery");
        if (ObjectHelper.isEmpty((Object)queryString)) {
            queryString = (String)message.getHeader("CamelHttpQuery", String.class);
        }
        String uriString = (String)message.getHeader("CamelHttpUri", String.class);
        uriString = exchange.getContext().resolvePropertyPlaceholders(uriString);
        if (uriString != null) {
            uriString = UnsafeUriCharactersEncoder.encodeHttpURI((String)uriString);
            URI uri = new URI(uriString);
            queryString = uri.getQuery();
        }
        return queryString;
    }

    public static URI resolveHttpURI(Exchange exchange) throws URISyntaxException {
        Message message = exchange.getMessage();
        String uri = (String)message.removeHeader("CamelRestHttpUri");
        if (ObjectHelper.isEmpty((Object)uri)) {
            uri = (String)message.getHeader("CamelHttpUri", String.class);
        }
        if (ObjectHelper.isEmpty((Object)uri)) {
            return null;
        }
        uri = exchange.getContext().resolvePropertyPlaceholders(uri);
        String path = (String)message.getHeader("CamelHttpPath", String.class);
        if (ObjectHelper.isNotEmpty((Object)path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() > 0) {
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri.concat(path);
            }
        }
        uri = UnsafeUriCharactersEncoder.encodeHttpURI((String)uri);
        return new URI(uri);
    }

    public static boolean isContentTypeMatching(Exchange exchange, String expected) {
        return VertxHttpHelper.isContentTypeMatching(expected, ExchangeHelper.getContentType((Exchange)exchange));
    }

    public static boolean isContentTypeMatching(String expected, String actual) {
        return actual != null && expected.equals(actual);
    }

    public static void writeObjectToStream(OutputStream stream, Object target) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(target);
        oos.flush();
        IOHelper.close((Closeable)oos);
    }

    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        Object answer;
        if (is == null) {
            return null;
        }
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static String getCharsetFromExchange(Exchange exchange) {
        String contentType;
        String charset = null;
        if (exchange != null && ObjectHelper.isEmpty((Object)(charset = HttpHelper.getCharsetFromContentType((String)(contentType = (String)exchange.getMessage().getHeader("Content-Type", String.class)))))) {
            charset = (String)exchange.getProperty("CamelCharsetName", String.class);
        }
        return charset;
    }

    private static KeyManagerFactory createKeyManagerFactory(SSLContextParameters sslContextParameters) throws Exception {
        KeyManagersParameters keyManagers = sslContextParameters.getKeyManagers();
        if (keyManagers == null) {
            return null;
        }
        String kmfAlgorithm = keyManagers.getAlgorithm();
        if (kmfAlgorithm == null) {
            kmfAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        KeyManagerFactory kmf = keyManagers.getProvider() == null ? KeyManagerFactory.getInstance(kmfAlgorithm) : KeyManagerFactory.getInstance(kmfAlgorithm, keyManagers.getProvider());
        char[] kmfPassword = null;
        if (keyManagers.getKeyPassword() != null) {
            kmfPassword = keyManagers.getKeyPassword().toCharArray();
        }
        KeyStore ks = keyManagers.getKeyStore() == null ? null : keyManagers.getKeyStore().createKeyStore();
        kmf.init(ks, kmfPassword);
        return kmf;
    }

    private static TrustManagerFactory createTrustManagerFactory(SSLContextParameters sslContextParameters) throws Exception {
        TrustManagersParameters trustManagers = sslContextParameters.getTrustManagers();
        if (trustManagers == null) {
            return null;
        }
        TrustManagerFactory tmf = null;
        if (trustManagers.getKeyStore() != null) {
            String tmfAlgorithm = trustManagers.getAlgorithm();
            if (tmfAlgorithm == null) {
                tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            tmf = trustManagers.getProvider() == null ? TrustManagerFactory.getInstance(tmfAlgorithm) : TrustManagerFactory.getInstance(tmfAlgorithm, trustManagers.getProvider());
            KeyStore ks = trustManagers.getKeyStore() == null ? null : trustManagers.getKeyStore().createKeyStore();
            tmf.init(ks);
        }
        return tmf;
    }
}

