/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import java.io.InputStream;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.vertx.http.VertxBufferConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class VertxBufferConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        VertxBufferConverterLoader.addTypeConverter(registry, byte[].class, Buffer.class, false, (type, exchange, value) -> VertxBufferConverter.toBytes((Buffer)value));
        VertxBufferConverterLoader.addTypeConverter(registry, Buffer.class, byte[].class, false, (type, exchange, value) -> VertxBufferConverter.toBuffer((byte[])value));
        VertxBufferConverterLoader.addTypeConverter(registry, Buffer.class, ByteBuf.class, false, (type, exchange, value) -> VertxBufferConverter.toBuffer((ByteBuf)value));
        VertxBufferConverterLoader.addTypeConverter(registry, Buffer.class, InputStream.class, false, (type, exchange, value) -> VertxBufferConverter.toBuffer((InputStream)value));
        VertxBufferConverterLoader.addTypeConverter(registry, Buffer.class, String.class, false, (type, exchange, value) -> VertxBufferConverter.toBuffer((String)value, exchange));
        VertxBufferConverterLoader.addTypeConverter(registry, String.class, Buffer.class, false, (type, exchange, value) -> VertxBufferConverter.toString((Buffer)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

