/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka.operations;

import io.vertx.kafka.client.common.TopicPartition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.util.ObjectHelper;

public class TopicSubscription {
    private final String configuredTopicName;
    private final Integer partitionId;
    private final Long seekToOffset;
    private final OffsetPosition seekToPosition;

    public TopicSubscription(String configuredTopicName, Integer partitionId, Long seekToOffset, String seekToPosition) {
        this.configuredTopicName = configuredTopicName;
        this.partitionId = partitionId;
        this.seekToOffset = seekToOffset;
        this.seekToPosition = ObjectHelper.equal((Object)seekToPosition, (Object)OffsetPosition.BEGINNING.string) ? OffsetPosition.BEGINNING : (ObjectHelper.equal((Object)seekToPosition, (Object)OffsetPosition.END.string) ? OffsetPosition.END : null);
    }

    public String getConfiguredTopicName() {
        return this.configuredTopicName;
    }

    public Set<String> getTopics() {
        return new HashSet<String>(Arrays.asList(this.configuredTopicName.split(",")));
    }

    public Integer getPartitionId() {
        return this.partitionId;
    }

    public Long getSeekToOffset() {
        return this.seekToOffset;
    }

    public OffsetPosition getSeekToPosition() {
        return this.seekToPosition;
    }

    public Set<TopicPartition> getTopicPartitions() {
        return this.getTopics().stream().map(topic -> new TopicPartition().setPartition(this.partitionId.intValue()).setTopic(topic)).collect(Collectors.toSet());
    }

    public static enum OffsetPosition {
        END("end"),
        BEGINNING("beginning");

        final String string;

        private OffsetPosition(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

