/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka;

import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.producer.KafkaHeader;
import io.vertx.kafka.client.producer.impl.KafkaHeaderImpl;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.vertx.kafka.serde.VertxKafkaHeaderSerializer;
import org.apache.camel.spi.HeaderFilterStrategy;

public final class VertxKafkaHeadersPropagation {
    private final HeaderFilterStrategy headerFilterStrategy;

    public VertxKafkaHeadersPropagation(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public List<KafkaHeader> getPropagatedHeaders(Message message) {
        return message.getHeaders().entrySet().stream().filter(entry -> VertxKafkaHeadersPropagation.shouldBeFiltered(entry, message.getExchange(), this.headerFilterStrategy)).map(VertxKafkaHeadersPropagation::getRecordHeader).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<String, Buffer> getPropagatedHeaders(List<KafkaHeader> headers, Message message) {
        return headers.stream().filter(entry -> VertxKafkaHeadersPropagation.shouldBeFiltered(new AbstractMap.SimpleEntry<String, Buffer>(entry.key(), entry.value()), message.getExchange(), this.headerFilterStrategy)).collect(Collectors.toMap(KafkaHeader::key, KafkaHeader::value));
    }

    private static boolean shouldBeFiltered(Map.Entry<String, Object> entry, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        return !headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange);
    }

    private static KafkaHeader getRecordHeader(Map.Entry<String, Object> entry) {
        Buffer headerValue = VertxKafkaHeaderSerializer.serialize(entry.getValue());
        if (headerValue == null) {
            return null;
        }
        return new KafkaHeaderImpl(entry.getKey(), headerValue);
    }
}

