/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka.serde;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.common.utils.Bytes;

public final class VertxKafkaTypeSerializer {
    private static final Map<String, Class<?>> TYPE_TO_CLASS = new HashMap();

    private VertxKafkaTypeSerializer() {
    }

    public static Object tryConvertToSerializedType(Message message, Object inputValue, String valueSerializer) {
        byte[] valueAsByteArr;
        ObjectHelper.notNull((Object)message, (String)"message");
        if (inputValue == null) {
            return null;
        }
        if ("org.apache.kafka.common.serialization.BytesSerializer".equals(valueSerializer) && (valueAsByteArr = VertxKafkaTypeSerializer.convertValue(message.getExchange(), inputValue, byte[].class)) != null) {
            return new Bytes(valueAsByteArr);
        }
        Object convertedValue = VertxKafkaTypeSerializer.convertValue(message.getExchange(), inputValue, TYPE_TO_CLASS.get(valueSerializer));
        if (ObjectHelper.isNotEmpty(convertedValue)) {
            return convertedValue;
        }
        return inputValue;
    }

    private static <T> T convertValue(Exchange exchange, Object inputValue, Class<T> type) {
        if (type == null) {
            return null;
        }
        return (T)exchange.getContext().getTypeConverter().tryConvertTo(type, exchange, inputValue);
    }

    private static void bind(String type, Class<?> typeClass) {
        TYPE_TO_CLASS.put(type, typeClass);
    }

    static {
        VertxKafkaTypeSerializer.bind("org.apache.kafka.common.serialization.StringSerializer", String.class);
        VertxKafkaTypeSerializer.bind("org.apache.kafka.common.serialization.ByteArraySerializer", byte[].class);
        VertxKafkaTypeSerializer.bind("org.apache.kafka.common.serialization.ByteBufferSerializer", ByteBuffer.class);
    }
}

