/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.consumer.KafkaConsumer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.component.vertx.kafka.VertxKafkaEndpoint;
import org.apache.camel.component.vertx.kafka.VertxKafkaHeadersPropagation;
import org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration;
import org.apache.camel.component.vertx.kafka.operations.VertxKafkaConsumerOperations;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxKafkaConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxKafkaConsumer.class);
    private KafkaConsumer<Object, Object> kafkaConsumer;

    public VertxKafkaConsumer(VertxKafkaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.kafkaConsumer = KafkaConsumer.create((Vertx)this.getEndpoint().getVertx(), (Properties)this.getConfiguration().createConsumerConfiguration());
        VertxKafkaConsumerOperations consumerOperations = new VertxKafkaConsumerOperations(this.kafkaConsumer, this.getConfiguration());
        consumerOperations.receiveEvents(this::onEventListener, this::onErrorListener);
    }

    protected void doStop() throws Exception {
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.close();
        }
        super.doStop();
    }

    public VertxKafkaConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public VertxKafkaEndpoint getEndpoint() {
        return (VertxKafkaEndpoint)super.getEndpoint();
    }

    private void onEventListener(KafkaConsumerRecord<Object, Object> record) {
        Exchange exchange = this.getEndpoint().createExchange(record);
        Map<String, Buffer> propagatedHeaders = new VertxKafkaHeadersPropagation(this.getConfiguration().getHeaderFilterStrategy()).getPropagatedHeaders(record.headers(), exchange.getIn());
        propagatedHeaders.forEach((key, value) -> exchange.getIn().setHeader(key, value));
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

            public void onComplete(Exchange exchange) {
            }

            public void onFailure(Exchange exchange) {
                VertxKafkaConsumer.this.processRollback(exchange);
            }
        });
        this.getAsyncProcessor().process(exchange, doneSync -> LOG.trace("Processing exchange [{}] done.", (Object)exchange));
    }

    private void onErrorListener(Throwable error) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.setException(error);
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
        }
    }

    private void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange.", exchange, (Throwable)cause);
        }
    }
}

