/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.vertx.kafka.DefaultVertxKafkaClientFactory;
import org.apache.camel.component.vertx.kafka.VertxKafkaClientFactory;
import org.apache.camel.component.vertx.kafka.VertxKafkaEndpoint;
import org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration;
import org.apache.camel.component.vertx.kafka.offset.DefaultVertxKafkaManualCommitFactory;
import org.apache.camel.component.vertx.kafka.offset.VertxKafkaManualCommitFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;

@org.apache.camel.spi.annotations.Component(value="vertx-kafka")
public class VertxKafkaComponent
extends DefaultComponent {
    @Metadata
    private VertxKafkaConfiguration configuration = new VertxKafkaConfiguration();
    private boolean managedVertx;
    @Metadata(label="advanced", autowired=true)
    private Vertx vertx;
    @Metadata(label="advanced")
    private VertxOptions vertxOptions;
    @Metadata(label="advanced", autowired=true)
    private VertxKafkaClientFactory vertxKafkaClientFactory = new DefaultVertxKafkaClientFactory();
    @Metadata(label="consumer,advanced", autowired=true)
    private VertxKafkaManualCommitFactory kafkaManualCommitFactory = new DefaultVertxKafkaManualCommitFactory();

    public VertxKafkaComponent() {
    }

    public VertxKafkaComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((Object)remaining)) {
            throw new IllegalArgumentException("Topic must be configured on endpoint using syntax kafka:topic");
        }
        VertxKafkaConfiguration configuration = this.configuration != null ? this.configuration.copy() : new VertxKafkaConfiguration();
        configuration.setTopic(remaining);
        VertxKafkaEndpoint endpoint = new VertxKafkaEndpoint(uri, (Component)this, configuration);
        if (PropertiesHelper.hasProperties(parameters, (String)"additionalProperties.")) {
            Map<String, Object> additionalProperties = endpoint.getConfiguration().getAdditionalProperties();
            additionalProperties.putAll(PropertiesHelper.extractProperties(parameters, (String)"additionalProperties."));
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.vertx == null) {
            this.vertx = this.vertxOptions != null ? Vertx.vertx((VertxOptions)this.vertxOptions) : Vertx.vertx();
            this.managedVertx = true;
        }
    }

    protected void doStop() throws Exception {
        if (this.managedVertx && this.vertx != null) {
            this.vertx.close();
            this.vertx = null;
        }
        super.doStop();
    }

    public VertxKafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(VertxKafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public VertxOptions getVertxOptions() {
        return this.vertxOptions;
    }

    public void setVertxOptions(VertxOptions vertxOptions) {
        this.vertxOptions = vertxOptions;
    }

    public VertxKafkaClientFactory getVertxKafkaClientFactory() {
        return this.vertxKafkaClientFactory;
    }

    public void setVertxKafkaClientFactory(VertxKafkaClientFactory vertxKafkaClientFactory) {
        this.vertxKafkaClientFactory = vertxKafkaClientFactory;
    }

    public VertxKafkaManualCommitFactory getKafkaManualCommitFactory() {
        return this.kafkaManualCommitFactory;
    }

    public void setKafkaManualCommitFactory(VertxKafkaManualCommitFactory kafkaManualCommitFactory) {
        this.kafkaManualCommitFactory = kafkaManualCommitFactory;
    }
}

