/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka;

import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.KafkaConsumer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.vertx.kafka.VertxKafkaEndpoint;
import org.apache.camel.component.vertx.kafka.VertxKafkaHeadersPropagation;
import org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration;
import org.apache.camel.component.vertx.kafka.offset.VertxKafkaManualCommit;
import org.apache.camel.component.vertx.kafka.operations.VertxKafkaConsumerOperations;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.EmptyAsyncCallback;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxKafkaConsumer
extends DefaultConsumer
implements Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(VertxKafkaConsumer.class);
    private Synchronization onCompletion;
    private KafkaConsumer<Object, Object> kafkaConsumer;

    public VertxKafkaConsumer(VertxKafkaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.onCompletion = new ConsumerOnCompletion();
    }

    protected void doStart() throws Exception {
        super.doStart();
        String brokers = this.getEndpoint().getComponent().getVertxKafkaClientFactory().getBootstrapBrokers(this.getConfiguration());
        if (brokers != null) {
            LOG.debug("Creating KafkaConsumer connecting to BootstrapBrokers: {}", (Object)brokers);
        }
        this.kafkaConsumer = this.getEndpoint().getComponent().getVertxKafkaClientFactory().getVertxKafkaConsumer(this.getEndpoint().getVertx(), this.getConfiguration().createConsumerConfiguration());
        VertxKafkaConsumerOperations consumerOperations = new VertxKafkaConsumerOperations(this.kafkaConsumer, this.getConfiguration());
        consumerOperations.receiveEvents(this::onEventListener, this::onErrorListener);
    }

    protected void doStop() throws Exception {
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.close();
        }
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.pause();
        }
    }

    protected void doResume() throws Exception {
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.resume();
        }
    }

    public VertxKafkaConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public VertxKafkaEndpoint getEndpoint() {
        return (VertxKafkaEndpoint)super.getEndpoint();
    }

    private void onEventListener(KafkaConsumerRecord<Object, Object> record) {
        Exchange exchange = this.createExchange(record);
        Map<String, Buffer> propagatedHeaders = new VertxKafkaHeadersPropagation(this.getConfiguration().getHeaderFilterStrategy()).getPropagatedHeaders(record.headers(), exchange.getIn());
        propagatedHeaders.forEach((key, value) -> exchange.getIn().setHeader(key, value));
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(this.onCompletion);
        this.getAsyncProcessor().process(exchange, EmptyAsyncCallback.get());
    }

    private void onErrorListener(Throwable error) {
        this.getExceptionHandler().handleException("Error from Kafka consumer.", error);
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange.", exchange, (Throwable)cause);
        }
    }

    private Exchange createExchange(KafkaConsumerRecord<Object, Object> record) {
        Exchange exchange = this.createExchange(true);
        Message message = exchange.getIn();
        message.setBody(record.record().value());
        message.setHeader("CamelVertxKafkaPartitionId", (Object)record.partition());
        message.setHeader("CamelVertxKafkaTopic", (Object)record.topic());
        message.setHeader("CamelVertxKafkaOffset", (Object)record.offset());
        message.setHeader("CamelVertxKafkaHeaders", (Object)record.headers());
        message.setHeader("CamelVertxKafkaTimestamp", (Object)record.timestamp());
        message.setHeader("CamelVertxKafkaMessageKey", record.key());
        if (this.getConfiguration().isAllowManualCommit()) {
            message.setHeader("CamelVertxKafkaManualCommit", (Object)this.createKafkaManualCommit(this.kafkaConsumer, record.topic(), new TopicPartition(record.topic(), record.partition()), record.offset()));
        }
        return exchange;
    }

    private VertxKafkaManualCommit createKafkaManualCommit(KafkaConsumer<Object, Object> consumer, String topicName, TopicPartition partition, long offset) {
        return this.getEndpoint().getComponent().getKafkaManualCommitFactory().create(consumer, topicName, partition, offset);
    }

    private class ConsumerOnCompletion
    extends SynchronizationAdapter {
        private ConsumerOnCompletion() {
        }

        public void onFailure(Exchange exchange) {
            VertxKafkaConsumer.this.processRollback(exchange);
        }
    }
}

