/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka;

import io.vertx.core.Vertx;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.vertx.kafka.VertxKafkaComponent;
import org.apache.camel.component.vertx.kafka.VertxKafkaConsumer;
import org.apache.camel.component.vertx.kafka.VertxKafkaProducer;
import org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.7.0", scheme="vertx-kafka", title="Vert.x Kafka", syntax="vertx-kafka:topic", category={Category.MESSAGING})
public class VertxKafkaEndpoint
extends DefaultEndpoint {
    @UriParam
    private VertxKafkaConfiguration configuration = new VertxKafkaConfiguration();
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy;

    public VertxKafkaEndpoint() {
    }

    public VertxKafkaEndpoint(String uri, Component component, VertxKafkaConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new VertxKafkaProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        VertxKafkaConsumer vertxKafkaConsumer = new VertxKafkaConsumer(this, processor);
        this.configureConsumer((Consumer)vertxKafkaConsumer);
        return vertxKafkaConsumer;
    }

    public VertxKafkaComponent getComponent() {
        return (VertxKafkaComponent)super.getComponent();
    }

    public Vertx getVertx() {
        return this.getComponent().getVertx();
    }

    public VertxKafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(VertxKafkaConfiguration configuration) {
        this.configuration = configuration;
    }
}

